/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.tools.parsers.TypoParser;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.TypoOptions;

public class IncludeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "IncludeChange";
    public static final String COMMANDKEY = "_ CRP-13";
    public static final String CUSTOM_PARAMNAME = "custom";
    public static final String KEY_PARAMNAME = "key";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private UiComponents uiComponents;
    private IncludeUi includeUi;
    private Corpus corpus;
    private boolean custom = false;
    private LabelChange labelChange;
    private String attributes;

    public IncludeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = this.updateIncludeUi(session.getBdfServerEditor(), this.includeUi);
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.includechange", this.includeUi.getName());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        String key = this.getMandatory(KEY_PARAMNAME);
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        this.includeUi = this.getIncludeUi(key);
        if (this.includeUi == null) {
            throw BdfErrors.unknownParameterValue(KEY_PARAMNAME, key);
        }
        this.custom = this.requestHandler.isTrue(CUSTOM_PARAMNAME);
        if (this.custom) {
            this.labelChange = this.requestHandler.getLabelChange(TITLE_PARAMPREFIX, false);
        }
        this.attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
    }

    private IncludeUi getIncludeUi(String key) throws ErrorMessageException {
        try {
            key = SpecialIncludeUi.checkSpecialIncludeName(key);
            return (IncludeUi)this.uiComponents.getUiComponent(key);
        }
        catch (IllegalArgumentException iae) {
            try {
                ExtendedIncludeKey includeKey = ExtendedIncludeKey.parse(key);
                return (IncludeUi)this.uiComponents.getUiComponent(includeKey);
            }
            catch (ParseException pe) {
                throw BdfErrors.wrongParameterValue(KEY_PARAMNAME, key);
            }
        }
    }

    private boolean updateIncludeUi(BdfServerEditor bdfServerEditor, IncludeUi includeUi) {
        IncludeUiBuilder includeUiBuilder = IncludeUiBuilder.init(includeUi);
        LabelChangeBuilder labelChangerBuilder = includeUiBuilder.getLabelChangeBuilder();
        if (!this.custom) {
            includeUiBuilder.getLabelChangeBuilder().clear();
        } else {
            for (Label label : this.labelChange.getChangedLabels()) {
                Lang currentLang = label.getLang();
                TypoOptions typoOptions = TypoOptions.getTypoOptions(currentLang.toLocale());
                String labelString = label.getLabelString();
                String checkedLabelString = TypoParser.parseTypo(labelString, typoOptions);
                if (!checkedLabelString.equals(labelString)) {
                    CleanedString cleanedString = CleanedString.newInstance(checkedLabelString);
                    if (cleanedString == null) {
                        labelChangerBuilder.putRemovedLang(currentLang);
                        continue;
                    }
                    label = LabelUtils.toLabel(currentLang, cleanedString);
                }
                labelChangerBuilder.putLabel(label);
            }
            for (Lang lang : this.labelChange.getRemovedLangList()) {
                labelChangerBuilder.putRemovedLang(lang);
            }
        }
        AttributeParser.parse(includeUiBuilder.getAttributeChangeBuilder(), this.attributes);
        bdfServerEditor.putComponentUi(this.uiComponents, includeUiBuilder.toIncludeUi());
        return true;
    }
}

