/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.tools.parsers.DocumentChangeInfo;
import net.fichotheque.utils.AddendaUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.primitives.FileLength;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.FileName;

public class DocumentFileDownloadCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DocumentFileDownload";
    public static final String URL_PARAMNAME = "url";
    public static final String METHOD_PARAMNAME = "method";
    public static final String URL_METHOD_PARAMVALUE = "url";
    public static final String MIME_METHOD_PARAMVALUE = "mime";
    public static final String PARAM_METHOD_PARAMVALUE = "param";
    public static final String EXTENSION_PARAMNAME = "extension";
    private Addenda addenda;
    private HttpURLConnection httpURLConnection;
    private String basename;
    private String originalBasename;
    private String extension;

    public DocumentFileDownloadCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        File tmpFile = FilesUploadUtils.getTmpFile(this.bdfServer, this.extension);
        try (InputStream is = this.httpURLConnection.getInputStream();
             FileOutputStream os = new FileOutputStream(tmpFile);){
            IOUtils.copy(is, (OutputStream)os);
        }
        catch (IOException ioe) {
            throw BdfErrors.ioException(ioe);
        }
        this.setDone("_ done.addenda.documentfiledownload", new Object[0]);
        DocumentChangeInfo documentChangeInfo = DocumentChangeInfo.parse("bn=" + this.basename + ",tf=" + tmpFile.getName());
        this.putResultObject("obj.documentchangeinfo", documentChangeInfo);
        this.putResultObject("obj.string", this.originalBasename);
        this.putResultObject("obj.filelength", new FileLength(tmpFile.length()));
        this.putResultObject("obj.addenda", this.addenda);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        URL documentURL;
        this.addenda = this.requestHandler.getMandatoryAddenda();
        String checkedExtension = null;
        String extensionMethod = this.getMandatory(METHOD_PARAMNAME);
        if (extensionMethod.equals(PARAM_METHOD_PARAMVALUE)) {
            checkedExtension = this.getMandatory(EXTENSION_PARAMNAME);
            if (!AddendaUtils.testExtension(checkedExtension = checkedExtension.toLowerCase())) {
                throw BdfErrors.error("_ error.wrong.extension", checkedExtension);
            }
        }
        String urlString = this.getMandatory("url");
        try {
            documentURL = new URL(urlString);
        }
        catch (MalformedURLException mue) {
            throw BdfErrors.error("_ error.wrong.url", urlString);
        }
        String protocol = documentURL.getProtocol();
        if (protocol == null || protocol.isEmpty()) {
            throw BdfErrors.error("_ error.wrong.url", urlString);
        }
        switch (protocol) {
            case "http": 
            case "https": {
                break;
            }
            default: {
                throw BdfErrors.error("_ error.unknown.url_protocol", protocol);
            }
        }
        try {
            String fileNameString;
            HttpURLConnection urlConnection = (HttpURLConnection)documentURL.openConnection();
            urlConnection.setInstanceFollowRedirects(true);
            urlConnection.connect();
            int code = urlConnection.getResponseCode();
            if (code != 200) {
                throw BdfErrors.error("_ error.exception.url_httpcode", code);
            }
            String bn = "index";
            String urlExtension = "html";
            String path = documentURL.getPath();
            int idx = path.lastIndexOf("/");
            if (idx != -1 && (fileNameString = path.substring(idx + 1)).length() > 0) {
                try {
                    FileName fileName = FileName.parse(fileNameString);
                    bn = fileName.getBasename();
                    urlExtension = fileName.getExtension();
                }
                catch (ParseException pe) {
                    bn = fileNameString;
                }
            }
            if (checkedExtension == null) {
                if (extensionMethod.equals(MIME_METHOD_PARAMVALUE)) {
                    String mimetype = urlConnection.getContentType();
                    if (mimetype != null) {
                        MimeTypeResolver mimeTypeResolver = this.bdfServer.getMimeTypeResolver();
                        String preferredExtension = mimeTypeResolver.getPreferredExtension(mimetype);
                        if (preferredExtension == null) {
                            preferredExtension = urlExtension;
                        }
                        checkedExtension = preferredExtension;
                    }
                } else {
                    checkedExtension = urlExtension;
                }
            }
            this.httpURLConnection = urlConnection;
            if (!AddendaUtils.testExtension(checkedExtension.toLowerCase())) {
                throw BdfErrors.error("_ error.wrong.extension", bn);
            }
            this.extension = checkedExtension.toLowerCase();
            this.originalBasename = bn;
            this.basename = AddendaUtils.checkBasename(bn, this.addenda);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.url_io", documentURL);
        }
    }
}

