/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.sql;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CreateTableWriter {
    private final Writer writer;
    private final short mode;
    private final List<String> primaryKeyList = new ArrayList<String>();
    private boolean firstField = true;

    public CreateTableWriter(Writer writer, short mode) {
        this.writer = writer;
        this.mode = mode;
    }

    public void startTable(String tableName) throws IOException {
        this.firstField = true;
        this.primaryKeyList.clear();
        this.writer.write("CREATE TABLE");
        if (this.mode == 2) {
            this.writer.write(" IF NOT EXISTS");
        }
        this.writer.write(" ");
        this.writer.write(tableName);
        this.writer.write(" (");
    }

    public void addIntegerField(String fieldName, boolean isPrimary, String title) throws IOException {
        this.testFirstField();
        this.writer.write(fieldName);
        this.writer.write(" INTEGER");
        if (isPrimary) {
            this.primaryKeyList.add(fieldName);
        }
        this.writeTitle(title);
    }

    public void addDateField(String fieldName, boolean isPrimary, String title) throws IOException {
        this.testFirstField();
        this.writer.write(fieldName);
        this.writer.write(" DATE");
        if (isPrimary) {
            this.primaryKeyList.add(fieldName);
        }
        this.writeTitle(title);
    }

    public void addDoubleField(String fieldName, boolean isPrimary, String title) throws IOException {
        this.testFirstField();
        this.writer.write(fieldName);
        this.writer.write(" DOUBLE");
        if (isPrimary) {
            this.primaryKeyList.add(fieldName);
        }
        this.writeTitle(title);
    }

    public void addTextField(String fieldName, boolean isPrimary, String title) throws IOException {
        this.testFirstField();
        this.writer.write(fieldName);
        if (isPrimary) {
            this.writer.write(" VARCHAR(255)");
            this.primaryKeyList.add(fieldName);
        } else if (this.mode == 2) {
            this.writer.write(" LONGTEXT");
        } else {
            this.writer.write(" TEXT");
        }
        this.writeTitle(title);
    }

    private void writeTitle(String title) throws IOException {
        if (title == null) {
            return;
        }
        int length = title.length();
        this.writer.write(" COMMENT '");
        for (int i = 0; i < length; ++i) {
            char carac = title.charAt(i);
            if (carac == '\'') {
                this.writer.write("''");
                continue;
            }
            this.writer.write(carac);
        }
        this.writer.write("''");
    }

    public void endTable(String createOptions) throws IOException {
        int size = this.primaryKeyList.size();
        if (size > 0) {
            this.writer.write(", PRIMARY KEY (");
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    this.writer.write(", ");
                }
                this.writer.write(this.primaryKeyList.get(i));
            }
            this.writer.write(")");
        }
        this.writer.write(")");
        if (createOptions != null) {
            this.writer.write(" ");
            this.writer.write(createOptions);
        }
    }

    private void testFirstField() throws IOException {
        if (this.firstField) {
            this.firstField = false;
        } else {
            this.writer.write(", ");
        }
    }
}

