/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.models;

import java.text.ParseException;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.text.StringUtils;

public final class EmailCoreUtils {
    private static final short VALIDE_SPEC = 2;
    private static final short HORS_SPEC = 3;
    private static final short LT = 4;
    private static final short GT = 5;

    private EmailCoreUtils() {
    }

    public static EmailCore derive(EmailCore emailCore, String realName) {
        InternalEmailCore newEmailCore = new InternalEmailCore(emailCore.getAddrSpec());
        newEmailCore.setRealName(realName);
        return newEmailCore;
    }

    public static boolean areEqual(EmailCore ec1, EmailCore ec2) {
        if (!ec1.getAddrSpec().equals(ec2.getAddrSpec())) {
            return false;
        }
        return ec1.getRealName().equals(ec2.getRealName());
    }

    public static EmailCore parse(String s) throws ParseException {
        if (s == null) {
            throw new ParseException("s is null", 0);
        }
        if ((s = StringUtils.cleanString(s)).length() == 0) {
            throw new ParseException("s length is null", 0);
        }
        if (s.charAt(0) == '\"') {
            return EmailCoreUtils.parseWithQuote(s);
        }
        return EmailCoreUtils.parseWithoutQuote(s);
    }

    public static EmailCore parse(String addrSpec, String realName) throws ParseException {
        addrSpec = EmailCoreUtils.checkAddrspec(addrSpec.trim(), 0);
        InternalEmailCore emailCore = new InternalEmailCore(addrSpec);
        emailCore.setRealName(realName.trim());
        return emailCore;
    }

    private static EmailCore parseWithQuote(String chaine) throws ParseException {
        StringBuilder realNameBuffer = new StringBuilder();
        int departlt = 0;
        int taillechaine = chaine.length();
        boolean whitespace = false;
        for (int i = 1; i < taillechaine; ++i) {
            char carac = chaine.charAt(i);
            if (Character.isWhitespace(carac)) {
                whitespace = true;
                continue;
            }
            if (carac == '\\') {
                if (i == taillechaine - 1) continue;
                if (whitespace) {
                    whitespace = false;
                    realNameBuffer.append(' ');
                }
                realNameBuffer.append(chaine.charAt(i + 1));
                ++i;
                continue;
            }
            if (carac == '\"') {
                departlt = i + 1;
                break;
            }
            if (whitespace) {
                whitespace = false;
                realNameBuffer.append(' ');
            }
            realNameBuffer.append(carac);
        }
        if (departlt == 0) {
            throw new ParseException("no closing quote", chaine.length() - 1);
        }
        int departaddrspec = -1;
        for (int i = departlt; i < taillechaine; ++i) {
            char carac = chaine.charAt(i);
            if (carac != '<') continue;
            departaddrspec = i + 1;
        }
        if (departaddrspec == -1) {
            throw new ParseException("no begining <", chaine.length() - 1);
        }
        String addrSpec = EmailCoreUtils.checkAddrspec(chaine, departaddrspec);
        InternalEmailCore emailCore = new InternalEmailCore(addrSpec);
        emailCore.setRealName(realNameBuffer.toString());
        return emailCore;
    }

    private static EmailCore parseWithoutQuote(String chaine) throws ParseException {
        int departaddrspec = chaine.indexOf(60) + 1;
        String addrSpec = EmailCoreUtils.checkAddrspec(chaine, departaddrspec);
        InternalEmailCore emailCore = new InternalEmailCore(addrSpec);
        if (departaddrspec > 0) {
            emailCore.setRealName(chaine.substring(0, departaddrspec - 1).trim());
        }
        return emailCore;
    }

    private static String checkAddrspec(String chaine, int depart) throws ParseException {
        StringBuilder bufaddrspec = new StringBuilder();
        int taillechaine = chaine.length();
        boolean avecarobase = false;
        for (int i = depart; i < taillechaine; ++i) {
            char carac = chaine.charAt(i);
            if (Character.isISOControl(carac) || Character.isSpaceChar(carac)) continue;
            if (carac == '@') {
                if (avecarobase) {
                    throw new ParseException("invalid @ character", i);
                }
                if (bufaddrspec.length() == 0) {
                    throw new ParseException(chaine.substring(depart) + " starts with @ character", 0);
                }
                avecarobase = true;
                bufaddrspec.append('@');
                continue;
            }
            short test = EmailCoreUtils.testeChar(carac);
            if (test == 2) {
                bufaddrspec.append(carac);
                continue;
            }
            if (test == 5) {
                if (avecarobase) {
                    return bufaddrspec.toString();
                }
                throw new ParseException("closing > character without @", i);
            }
            throw new ParseException("invalid character", i);
        }
        if (avecarobase) {
            return bufaddrspec.toString();
        }
        throw new ParseException("missing @ character", chaine.length() - 1);
    }

    private static short testeChar(char c) {
        if (c == '<') {
            return 4;
        }
        if (c == '>') {
            return 5;
        }
        if (c > '~') {
            return 3;
        }
        if (c == '.') {
            return 2;
        }
        if (c >= '0' && c <= '9') {
            return 2;
        }
        if (c >= 'A' && c <= 'Z') {
            return 2;
        }
        if (c >= '^' && c <= '~') {
            return 2;
        }
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '=': 
            case '?': {
                return 2;
            }
        }
        return 3;
    }

    private static class InternalEmailCore
    implements EmailCore {
        String addrSpec;
        String realName = "";

        private InternalEmailCore(String addrSpec) {
            this.addrSpec = addrSpec;
        }

        private InternalEmailCore(EmailCore emailCore) {
            this.addrSpec = emailCore.getAddrSpec();
            this.realName = emailCore.getRealName();
        }

        @Override
        public String getRealName() {
            return this.realName;
        }

        @Override
        public String getAddrSpec() {
            return this.addrSpec;
        }

        private void setRealName(String realName) {
            this.realName = realName;
        }
    }
}

