/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.io.IOException;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.instruction.InstructionErrorHandler;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LineLog;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.logging.LineMessageException;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.logging.SourceLog;
import net.mapeadores.util.logging.SourceLogBuilder;
import net.mapeadores.util.logging.SourceLogDOMReader;
import net.mapeadores.util.logging.SourceLogXMLPart;
import net.mapeadores.util.logging.SourceLogs;
import net.mapeadores.util.logging.SourceLogsBuilder;
import net.mapeadores.util.logging.SourceMessage;
import net.mapeadores.util.misc.ArrayUtils;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class LogUtils {
    public static final SourceLogs EMPTY_SOURCELOGS = new EmptySourceLogs();
    public static final MessageHandler NULL_MESSAGEHANDLER = new NullMultiMessageHandler();
    public static final MultiMessageHandler NULL_MULTIMESSAGEHANDLER = new NullMultiMessageHandler();
    public static final LineMessageHandler NULL_LINEMESSAGEHANDLER = new NullLineMessageHandler();
    public static final LineLogs EMPTY_LINELOGS = new EmptyLineLogs();

    private LogUtils() {
    }

    public static LineMessage toLineMessage(String category, int lineNumber, String messageKey, Object ... messageValues) {
        if (messageKey == null) {
            throw new IllegalArgumentException("messageKey is null");
        }
        return new InternalLineMessage(category, lineNumber, messageKey, LogUtils.toList(messageValues));
    }

    public static LineMessage toLineMessage(String category, int lineNumber, Message message) {
        return new InternalLineMessage(category, lineNumber, message.getMessageKey(), message.getMessageValueList());
    }

    public static String toXmlString(SourceLogs logs) {
        StringBuilder buf = new StringBuilder();
        try {
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            XMLUtils.appendXmlDeclaration(xmlWriter);
            SourceLogXMLPart messageXMLPart = new SourceLogXMLPart(xmlWriter);
            messageXMLPart.addLogs(logs);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String toXmlString(SourceLog log) {
        StringBuilder buf = new StringBuilder();
        try {
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            XMLUtils.appendXmlDeclaration(xmlWriter);
            SourceLogXMLPart messageXMLPart = new SourceLogXMLPart(xmlWriter);
            messageXMLPart.addLog(log);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static SourceLog readLog(String name, String xmlString) {
        SourceLogBuilder logBuilder = new SourceLogBuilder(name);
        DocumentBuilder docBuilder = DOMUtils.newDocumentBuilder();
        try {
            Document document = docBuilder.parse(new InputSource(new StringReader(xmlString)));
            SourceLogDOMReader reader = new SourceLogDOMReader(NULL_MESSAGEHANDLER);
            reader.readLog(logBuilder, document.getDocumentElement(), "");
            return logBuilder.toSourceLog();
        }
        catch (SAXException saxe) {
            DomMessages.saxException(logBuilder, saxe);
            return logBuilder.toSourceLog();
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException(ioe);
        }
    }

    public static SourceLogs readLogs(String xmlString) {
        SourceLogsBuilder logBuilder = new SourceLogsBuilder();
        DocumentBuilder docBuilder = DOMUtils.newDocumentBuilder();
        try {
            Document document = docBuilder.parse(new InputSource(new StringReader(xmlString)));
            SourceLogDOMReader reader = new SourceLogDOMReader(NULL_MESSAGEHANDLER);
            reader.readLogs(logBuilder, document.getDocumentElement(), "");
        }
        catch (SAXException saxe) {
            logBuilder.setCurrentSource("logfile");
            DomMessages.saxException(logBuilder, saxe);
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException(ioe);
        }
        return logBuilder.toSourceLogs();
    }

    public static boolean printHtml(HtmlPrinter hp, SourceLogs logs, String listCssClasses) {
        if (logs.isEmpty()) {
            return false;
        }
        hp.UL(listCssClasses);
        for (SourceLog log : logs) {
            List<SourceMessage> messageList = log.getSourceMessageList();
            if (messageList.isEmpty()) continue;
            hp.LI();
            hp.P().CODE("cm-link").__escape(log.getName())._CODE()._P();
            hp.UL();
            for (SourceMessage sourceMessage : messageList) {
                hp.LI().P().CODE("cm-qualifier").__escape('[').__escape(sourceMessage.getCategory()).__escape(']')._CODE().__space().SPAN("cm-quote").__localize(sourceMessage)._SPAN()._P()._LI();
            }
            hp._UL();
            hp._LI();
        }
        hp._UL();
        return true;
    }

    public static String getClassName(String category) {
        if (category.startsWith("severe.")) {
            return "global-ErrorMessage";
        }
        if (category.startsWith("warning.")) {
            return "global-WarningMessage";
        }
        return "";
    }

    public static InstructionErrorHandler encapsulate(LineMessageHandler lineMessageHandler, String category, int lineNumber) {
        return new LineInstructionErrorHandler(lineMessageHandler, category, lineNumber);
    }

    public static List<SourceMessage> wrap(SourceMessage[] array) {
        return new SourceMessageList(array);
    }

    public static List<LineMessage> wrap(LineMessage[] array) {
        return new LineMessageList(array);
    }

    public static void handleSAXException(String category, SAXException saxException, LineMessageHandler lineMessageHandler) {
        if (saxException instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)saxException;
            lineMessageHandler.addMessage(category, spe.getLineNumber(), "_ error.exception.xml.sax_parse", saxException.getMessage(), String.valueOf(spe.getLineNumber()), String.valueOf(spe.getColumnNumber()));
        } else {
            lineMessageHandler.addMessage(category, 0, "_ error.exception.xml.sax", saxException.getMessage());
        }
    }

    public static void handleTransformerException(String category, TransformerException transformerException, String systemId, LineMessageHandler lineMessageHandler) {
        SourceLocator sourceLocator = transformerException.getLocator();
        boolean done = false;
        if (sourceLocator != null) {
            String sourceSystemId = sourceLocator.getSystemId();
            int lineNumber = sourceLocator.getLineNumber();
            if (lineNumber != -1 && (sourceSystemId == null || sourceSystemId.equals(systemId))) {
                lineMessageHandler.addMessage(category, lineNumber, "_ error.exception.xml.xslt", transformerException.getMessage());
                done = true;
            }
        }
        if (done) {
            return;
        }
        String message = transformerException.getMessage().trim();
        int idx = message.indexOf("line ");
        if (idx > -1) {
            String end;
            String number = end = message.substring(idx + 5).trim();
            int spaceIdx = end.indexOf(":");
            if (spaceIdx > -1) {
                number = end.substring(0, spaceIdx);
                end = end.substring(spaceIdx + 1).trim();
            }
            try {
                int lineNumber = Integer.parseInt(number);
                String currentSystemId = message.substring(0, idx).trim();
                if (currentSystemId.endsWith(":")) {
                    currentSystemId = currentSystemId.substring(0, currentSystemId.length() - 1).trim();
                }
                if (currentSystemId.isEmpty() || currentSystemId.equals(systemId)) {
                    lineMessageHandler.addMessage(category, lineNumber, "_ error.exception.xml.xslt", end);
                    done = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!done) {
            lineMessageHandler.addMessage(category, 0, "_ error.exception.xml.xslt", transformerException.getMessageAndLocation());
        }
    }

    public static CommandMessage error(String messageKey, Object ... messageValues) {
        if (messageKey == null) {
            throw new IllegalArgumentException("messageKey is null");
        }
        return new SimpleCommandMessage(messageKey, LogUtils.toList(messageValues), true);
    }

    public static CommandMessage error(Message message) {
        return new SimpleCommandMessage(message.getMessageKey(), message.getMessageValueList(), true);
    }

    public static CommandMessage done(String messageKey, Object ... messageValues) {
        if (messageKey == null) {
            throw new IllegalArgumentException("messageKey is null");
        }
        return new SimpleCommandMessage(messageKey, LogUtils.toList(messageValues), false);
    }

    public static CommandMessage done(Message message) {
        return new SimpleCommandMessage(message.getMessageKey(), message.getMessageValueList(), false);
    }

    private static List<Object> toList(Object[] messageValues) {
        if (messageValues == null) {
            return LocalisationUtils.EMPTY_VALUELIST;
        }
        return ArrayUtils.wrap(messageValues);
    }

    private static class InternalLineMessage
    implements LineMessage {
        private final String category;
        private final String messageKey;
        private final List<Object> messageValueList;
        private final int lineNumber;

        private InternalLineMessage(String category, int lineNumber, String messageKey, List<Object> messageValueList) {
            this.category = category;
            this.lineNumber = lineNumber;
            this.messageKey = messageKey;
            this.messageValueList = messageValueList;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public String getMessageKey() {
            return this.messageKey;
        }

        @Override
        public List<Object> getMessageValueList() {
            return this.messageValueList;
        }
    }

    private static class LineInstructionErrorHandler
    implements InstructionErrorHandler {
        private final String category;
        private final LineMessageHandler lineMessageHandler;
        private final int lineNumber;

        private LineInstructionErrorHandler(LineMessageHandler lineMessageHandler, String category, int lineNumber) {
            this.lineMessageHandler = lineMessageHandler;
            this.category = category;
            this.lineNumber = lineNumber;
        }

        @Override
        public void invalidAsciiCharacterError(String part, int row, int col) {
            this.addMessage("_ error.wrong.character_notascii", part, row, col);
        }

        @Override
        public void invalidEndCharacterError(String part, int row, int col) {
            this.addMessage("_ error.wrong.character_end", part, row, col);
        }

        @Override
        public void invalidSeparatorCharacterError(String part, int row, int col) {
            this.addMessage("_ error.wrong.character_separator", part, row, col);
        }

        private void addMessage(String messageKey, String part, int row, int col) {
            this.lineMessageHandler.addMessage(this.category, this.lineNumber, messageKey, part, row, col);
        }
    }

    private static class SourceMessageList
    extends AbstractList<SourceMessage>
    implements RandomAccess {
        private final SourceMessage[] array;

        private SourceMessageList(SourceMessage[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SourceMessage get(int index) {
            return this.array[index];
        }
    }

    private static class LineMessageList
    extends AbstractList<LineMessage>
    implements RandomAccess {
        private final LineMessage[] array;

        private LineMessageList(LineMessage[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public LineMessage get(int index) {
            return this.array[index];
        }
    }

    private static class SimpleCommandMessage
    implements CommandMessage {
        private final String messageKey;
        private final List<Object> messageValueList;
        private final boolean isError;

        private SimpleCommandMessage(String messageKey, List<Object> messageValueList, boolean isError) {
            this.messageKey = messageKey;
            this.messageValueList = messageValueList;
            this.isError = isError;
        }

        @Override
        public String getMessageKey() {
            return this.messageKey;
        }

        @Override
        public List<Object> getMessageValueList() {
            return this.messageValueList;
        }

        @Override
        public boolean isErrorMessage() {
            return this.isError;
        }

        @Override
        public List<Message> getMultiErrorList() {
            return LocalisationUtils.EMPTY_MESSAGELIST;
        }

        @Override
        public SourceLogs getCommandLogs() {
            return null;
        }
    }

    private static class EmptySourceLogs
    extends AbstractList<SourceLog>
    implements SourceLogs {
        private EmptySourceLogs() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public SourceLog get(int i) {
            throw new IndexOutOfBoundsException("size = 0");
        }
    }

    private static class NullMultiMessageHandler
    implements MultiMessageHandler {
        private NullMultiMessageHandler() {
        }

        @Override
        public void addMessage(String category, Message message) {
        }

        @Override
        public void addMessage(String category, String messageKey, Object ... messageValues) {
        }

        @Override
        public void setCurrentSource(String uri) {
        }
    }

    private static class NullLineMessageHandler
    implements LineMessageHandler {
        private NullLineMessageHandler() {
        }

        @Override
        public void addMessage(LineMessage lineMessage) {
        }

        @Override
        public void addMessage(String category, int lineNumber, Message message) {
        }

        @Override
        public void addMessage(String category, int lineNumber, String messageKey, Object ... messageValues) {
        }

        @Override
        public void addMessage(LineMessageException lme) {
        }
    }

    private static class EmptyLineLogs
    extends AbstractList<LineLog>
    implements LineLogs {
        private EmptyLineLogs() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public LineLog get(int i) {
            throw new IndexOutOfBoundsException("size = 0");
        }
    }

    public static class ShouldNotOccurMessageHandler
    implements MessageHandler {
        @Override
        public void addMessage(String category, Message message) {
            StringBuilder buf = new StringBuilder();
            buf.append(category);
            buf.append(" / ");
            buf.append(message.getMessageKey());
            for (Object value : message.getMessageValueList()) {
                buf.append(" / ");
                buf.append(value);
            }
            throw new ShouldNotOccurException(buf.toString());
        }
    }
}

