/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.ini;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.function.BiConsumer;

public final class IniParser {
    private IniParser() {
    }

    public static void parseIni(InputStream inputStream, Map<String, String> stringMap) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
        IniParser.parseIni((Reader)reader, stringMap);
    }

    public static void parseIni(InputStream inputStream, BiConsumer<String, String> consumer) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
        IniParser.parseIni((Reader)reader, consumer);
    }

    public static void parseIni(Reader reader, Map<String, String> stringMap) throws IOException {
        IniParser.parseIni(reader, (String key, String value) -> stringMap.put((String)key, (String)value));
    }

    public static void parseIni(Reader reader, BiConsumer<String, String> consumer) throws IOException {
        String line;
        BufferedReader bufReader = !(reader instanceof BufferedReader) ? new BufferedReader(reader) : (BufferedReader)reader;
        while ((line = bufReader.readLine()) != null) {
            IniParser.parseLine(line, consumer);
        }
    }

    public static void parseLine(String line, BiConsumer<String, String> consumer) {
        if ((line = line.trim()).length() == 0) {
            return;
        }
        switch (line.charAt(0)) {
            case '!': 
            case '#': 
            case ';': 
            case '[': {
                return;
            }
        }
        int idx = line.indexOf(61);
        if (idx < 1) {
            return;
        }
        String key = line.substring(0, idx).trim();
        String value = line.substring(idx + 1).trim();
        value = IniParser.parseValue(value, 0, value.length());
        consumer.accept(key, value);
    }

    private static String parseValue(CharSequence charSequence, int start, int len) {
        int stopIndex = start + len;
        StringBuilder buf = new StringBuilder();
        block3: for (int i = start; i < stopIndex; ++i) {
            int precedingIndices = i - start;
            int remainingIndices = stopIndex - i - 1;
            char carac = charSequence.charAt(i);
            switch (carac) {
                case '\\': {
                    i = IniParser.testAntiSlash(charSequence, i, remainingIndices, buf);
                    continue block3;
                }
                default: {
                    buf.append(carac);
                }
            }
        }
        return buf.toString();
    }

    private static int testAntiSlash(CharSequence charSequence, int currentIndex, int remainingIndices, StringBuilder buf) {
        if (remainingIndices == 0) {
            buf.append('\\');
            return currentIndex;
        }
        char nextChar = charSequence.charAt(currentIndex + 1);
        switch (nextChar) {
            case '\\': {
                buf.append('\\');
                return currentIndex + 1;
            }
            case 'n': {
                buf.append('\n');
                return currentIndex + 1;
            }
            case 'r': {
                buf.append('\r');
                return currentIndex + 1;
            }
            case 't': {
                buf.append('\t');
                return currentIndex + 1;
            }
            case 'u': {
                int min = currentIndex + 2 + Math.min(4, remainingIndices - 1);
                int p = 0;
                int result = 0;
                for (int i = currentIndex + 2; i < min; ++i) {
                    char carac = charSequence.charAt(i);
                    int digit = Character.digit(carac, 16);
                    if (digit < 0) continue;
                    result *= 16;
                    result += digit;
                    ++p;
                }
                if (p == 0) {
                    buf.append("\\u");
                } else {
                    buf.append((char)result);
                }
                return currentIndex + 1 + p;
            }
        }
        buf.append('\\');
        return currentIndex;
    }
}

