/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.format;

import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.format.Calcul;
import net.mapeadores.util.format.FormatDef;
import net.mapeadores.util.primitives.PrimUtils;

public abstract class FormatDefBuilder {
    private boolean formatPatternListInit = false;
    private final Map<Integer, InternalInnerSeparator> innerSeparatorMap = new HashMap<Integer, InternalInnerSeparator>();
    private final Map<Long, InternalSourceSeparator> sourceSeparatorMap = new HashMap<Long, InternalSourceSeparator>();

    public FormatDefBuilder addFormatPattern(String fP) {
        if (fP != null && (fP = fP.trim()).length() == 0) {
            fP = null;
        }
        if (fP == null && !this.formatPatternListInit) {
            return this;
        }
        this.formatPatternListInit = true;
        this.addCleanedFormatPattern(fP);
        return this;
    }

    public FormatDefBuilder setCastType(String castType) {
        this.put("cast", castType);
        return this;
    }

    public FormatDefBuilder setFixedChar(char carac) {
        this.put("fixedchar", Character.valueOf(carac));
        return this;
    }

    public FormatDefBuilder putBooleanValue(String key, boolean value) {
        this.put(key, value);
        return this;
    }

    public FormatDefBuilder putStringValue(String key, String value) {
        if (value == null) {
            this.remove(key);
        } else {
            this.put(key, value);
        }
        return this;
    }

    public FormatDefBuilder putIntValue(String key, int value) {
        if (value < 0) {
            value = -1;
        }
        this.put(key, value);
        return this;
    }

    public FormatDefBuilder setCalcul(Calcul calcul) {
        if (calcul == null) {
            this.remove("calc");
        } else {
            this.put("calc", calcul);
        }
        return this;
    }

    public FormatDefBuilder setSum(boolean withSum, String sumCastType) {
        if (withSum) {
            this.put("sum", sumCastType);
        } else {
            this.remove("sum");
        }
        return this;
    }

    public FormatDefBuilder setFormula(boolean isFormula, String formulaCastType) {
        if (isFormula) {
            this.put("formula", formulaCastType);
        } else {
            this.remove("formula");
        }
        return this;
    }

    public FormatDefBuilder setInternalSeparator(int sourceIndex, String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("separator is null");
        }
        InternalInnerSeparator innerSeparator = this.innerSeparatorMap.get(sourceIndex);
        if (innerSeparator == null) {
            innerSeparator = new InternalInnerSeparator(sourceIndex, separator);
            this.innerSeparatorMap.put(sourceIndex, innerSeparator);
            this.addInnerSeparator(innerSeparator);
        } else {
            innerSeparator.setSeparator(separator);
        }
        return this;
    }

    public FormatDefBuilder setSourceSeparator(int sourceIndex1, int sourceIndex2, String separator) {
        long l;
        InternalSourceSeparator sourceSeparator;
        if (separator == null) {
            throw new IllegalArgumentException("separator is null");
        }
        if (sourceIndex1 == sourceIndex2) {
            throw new IllegalArgumentException("sourceIndex1 == sourceIndex2");
        }
        if (sourceIndex1 > sourceIndex2) {
            int tmp = sourceIndex1;
            sourceIndex1 = sourceIndex2;
            sourceIndex2 = tmp;
        }
        if ((sourceSeparator = this.sourceSeparatorMap.get(l = PrimUtils.toLong(sourceIndex1, sourceIndex2))) == null) {
            sourceSeparator = new InternalSourceSeparator(sourceIndex1, sourceIndex2, separator);
            this.sourceSeparatorMap.put(l, sourceSeparator);
            this.addSourceSeparator(sourceSeparator);
        } else {
            sourceSeparator.setSeparator(separator);
        }
        return this;
    }

    protected abstract void put(String var1, Object var2);

    protected abstract void remove(String var1);

    protected abstract void addInnerSeparator(FormatDef.InnerSeparator var1);

    protected abstract void addSourceSeparator(FormatDef.SourceSeparator var1);

    protected abstract void addCleanedFormatPattern(String var1);

    private static class InternalInnerSeparator
    implements FormatDef.InnerSeparator {
        private final int sourceIndex;
        private String separator;

        private InternalInnerSeparator(int sourceIndex, String separator) {
            this.sourceIndex = sourceIndex;
            this.separator = separator;
        }

        @Override
        public int getSourceIndex() {
            return this.sourceIndex;
        }

        @Override
        public String getSeparator() {
            return this.separator;
        }

        private void setSeparator(String separator) {
            this.separator = separator;
        }
    }

    private static class InternalSourceSeparator
    implements FormatDef.SourceSeparator {
        private final int sourceIndex1;
        private final int sourceIndex2;
        private String separator;

        private InternalSourceSeparator(int sourceIndex1, int sourceIndex2, String separator) {
            this.sourceIndex1 = sourceIndex1;
            this.sourceIndex2 = sourceIndex2;
            this.separator = separator;
        }

        @Override
        public int getSourceIndex1() {
            return this.sourceIndex1;
        }

        @Override
        public int getSourceIndex2() {
            return this.sourceIndex2;
        }

        @Override
        public String getSeparator() {
            return this.separator;
        }

        private void setSeparator(String separator) {
            this.separator = separator;
        }
    }
}

