/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.conditions;

import java.io.IOException;
import net.mapeadores.util.conditions.ConditionsConstants;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextConditionBuilder;
import net.mapeadores.util.conditions.TextTest;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ConditionsXMLStorage {
    private ConditionsXMLStorage() {
    }

    public static void appendTestText(XMLWriter xmlWriter, TextCondition textCondition) throws IOException {
        for (TextTest textTest : textCondition.getIncludingTextTestList()) {
            ConditionsXMLStorage.appendTestText(xmlWriter, textTest);
        }
        for (TextTest textTest : textCondition.getExcludingTextTestList()) {
            ConditionsXMLStorage.appendTestText(xmlWriter, textTest);
        }
    }

    public static void appendTestText(XMLWriter xmlWriter, TextTest textTest) throws IOException {
        xmlWriter.startOpenTag("text-test");
        xmlWriter.addAttribute("type", ConditionsUtils.testTypeToString(textTest.getTestType()));
        xmlWriter.endOpenTag();
        xmlWriter.addText(textTest.getText());
        xmlWriter.closeTag("text-test", false);
    }

    public static TextCondition readTextCondition(Element element) {
        String logicalOperator = element.getAttribute("operator");
        if (logicalOperator.isEmpty()) {
            logicalOperator = element.getAttribute("mode");
        }
        logicalOperator = ConditionsConstants.checkLogicalOperator(logicalOperator, "or");
        String q = element.getAttribute("q");
        if (q.isEmpty()) {
            q = element.getAttribute("raw");
        }
        if (q.length() > 0) {
            String qType = element.getAttribute("q-type");
            if (qType.equals("simple")) {
                return ConditionsUtils.parseSimpleCondition(q, logicalOperator);
            }
            return ConditionsUtils.parseCondition(q, logicalOperator);
        }
        TextConditionBuilder conditionBuilder = new TextConditionBuilder(logicalOperator);
        NodeList liste = element.getChildNodes();
        block7: for (int i = 0; i < liste.getLength(); ++i) {
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element child = (Element)nd;
            switch (child.getTagName()) {
                case "text-test": 
                case "condition": {
                    TextTest textTest = ConditionsXMLStorage.readTextTest(child);
                    if (textTest == null) continue block7;
                    conditionBuilder.addTextTest(textTest);
                    continue block7;
                }
            }
        }
        return conditionBuilder.toTextCondition();
    }

    private static TextTest readTextTest(Element element) {
        short testType;
        String text = XMLUtils.getData(element);
        String type = element.getAttribute("type");
        if (type.isEmpty()) {
            testType = 13;
        } else {
            try {
                testType = ConditionsUtils.testTypeToShort(type);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        return ConditionsUtils.toTextTest(testType, text);
    }
}

