/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.junction;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.Tie;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.text.StringUtils;

public class JunctionChangeBuilder {
    private final Set<String> removedModeSet = new LinkedHashSet<String>();
    private final Map<String, Tie> tieMap = new LinkedHashMap<String, Tie>();

    public JunctionChangeBuilder addRemovedMode(String mode) {
        this.removedModeSet.add(mode);
        return this;
    }

    public JunctionChangeBuilder addTie(Tie tie) {
        this.tieMap.put(tie.getMode(), tie);
        return this;
    }

    public JunctionChange toJunctionChange() {
        return JunctionChangeBuilder.toJunctionChange(this.removedModeSet, this.tieMap.values());
    }

    public static JunctionChangeBuilder init() {
        return new JunctionChangeBuilder();
    }

    static JunctionChange toJunctionChange(Collection<String> removedModes, Collection<Tie> changedTies) {
        List<String> removedModeArray = StringUtils.toList(removedModes);
        List<Tie> changedTieArray = JunctionUtils.wrap(changedTies.toArray(new Tie[changedTies.size()]));
        return new InternalJunctionChange(removedModeArray, changedTieArray);
    }

    private static class InternalJunctionChange
    implements JunctionChange {
        private final List<String> removedModeArray;
        private final List<Tie> changedTieArray;

        private InternalJunctionChange(List<String> removedModeArray, List<Tie> changedTieArray) {
            this.removedModeArray = removedModeArray;
            this.changedTieArray = changedTieArray;
        }

        @Override
        public List<String> getRemovedModeList() {
            return this.removedModeArray;
        }

        @Override
        public List<Tie> getChangedTieList() {
            return this.changedTieArray;
        }
    }
}

