/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation;

import java.util.AbstractList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import net.fichotheque.importation.ParseResult;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.logging.LineLogsBuilder;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.SourceLog;
import net.mapeadores.util.logging.SourceLogBuilder;

public class ParseResultBuilder {
    private final String type;
    private final SourceLogBuilder columnLogBuilder = new SourceLogBuilder("init");
    private final LineLogsBuilder lineLogsBuilder = new LineLogsBuilder();
    private final Map<String, ParseResult.ResultItem> resultItemMap = new LinkedHashMap<String, ParseResult.ResultItem>();
    private String path = "";

    public ParseResultBuilder(String type) {
        this.type = type;
    }

    public LineMessageHandler getLineMessageHandler() {
        return this.lineLogsBuilder;
    }

    public ParseResultBuilder missingColumn(String columnName) {
        this.columnLogBuilder.addMessage("severe.column", "_ error.empty.tableimport.column", columnName);
        return this;
    }

    public ParseResultBuilder missingColumns(String columnName1, String columnName2) {
        this.columnLogBuilder.addMessage("severe.column", "_ error.empty.tableimport.columns", columnName1, columnName2);
        return this;
    }

    public ParseResultBuilder duplicateColumn(String columnName) {
        this.columnLogBuilder.addMessage("warning.column", "_ error.unsupported.tableimport.duplicatecolumn", columnName);
        return this;
    }

    public ParseResultBuilder unknownColumn(String columnName) {
        this.columnLogBuilder.addMessage("warning.column", "_ error.unknown.tableimport.column", columnName);
        return this;
    }

    public ParseResultBuilder unknownSubset(String subsetName) {
        this.columnLogBuilder.addMessage("warning.column", "_ error.unknown.subset", subsetName);
        return this;
    }

    public ParseResultBuilder wrongColumn(String columnName) {
        this.columnLogBuilder.addMessage("warning.column", "_ error.wrong.tableimport.column", columnName);
        return this;
    }

    public ParseResultBuilder notUsableIdalpha(String columnName) {
        this.columnLogBuilder.addMessage("warning.column", "_ error.unsupported.tableimport.notusableidalpha", columnName);
        return this;
    }

    public ParseResultBuilder notAvailableColumn(String columnName) {
        this.columnLogBuilder.addMessage("warning.column", "_ error.unsupported.tableimport.notavailablecolumn", columnName);
        return this;
    }

    public ParseResultBuilder addParseErrorMessage(int lineNumber, Message message) {
        this.lineLogsBuilder.addMessage("severe.parse", lineNumber, message);
        return this;
    }

    public ParseResultBuilder missingIdColumn(int lineNumber) {
        this.lineLogsBuilder.addMessage("severe.parse", lineNumber, "_ error.empty.tableimport.missingidcolumn", new Object[0]);
        return this;
    }

    public ParseResultBuilder unknownId(int lineNumber, String idstring) {
        this.lineLogsBuilder.addMessage("severe.fichotheque", lineNumber, "_ error.unknown.id", idstring);
        return this;
    }

    public ParseResultBuilder unknownIdalpha(int lineNumber, String idalpha) {
        this.lineLogsBuilder.addMessage("severe.fichotheque", lineNumber, "_ error.unknown.idalpha", idalpha);
        return this;
    }

    public ParseResultBuilder notIntegerId(int lineNumber, String idstring) {
        this.lineLogsBuilder.addMessage("severe.parse", lineNumber, "_ error.wrong.tableimport.notintegerid", idstring);
        return this;
    }

    public ParseResultBuilder existingId(int lineNumber, String idstring) {
        this.lineLogsBuilder.addMessage("severe.fichotheque", lineNumber, "_ error.existing.id", idstring);
        return this;
    }

    public ParseResultBuilder existingIdalpha(int lineNumber, String idalpha) {
        this.lineLogsBuilder.addMessage("severe.fichotheque", lineNumber, "_ error.existing.idalpha", idalpha);
        return this;
    }

    public ParseResultBuilder selfParent(int lineNumber, String parentIdalpha) {
        this.lineLogsBuilder.addMessage("severe.fichotheque", lineNumber, "_ error.unsupported.selfparent", new Object[0]);
        return this;
    }

    public ParseResultBuilder unknownStatus(int lineNumber, String status) {
        this.lineLogsBuilder.addMessage("severe.fichotheque", lineNumber, "_ error.unknown.status", status);
        return this;
    }

    public ParseResultBuilder wrongDate(int lineNumber, String dateString) {
        this.lineLogsBuilder.addMessage("severe.parse", lineNumber, "_ error.wrong.date", dateString);
        return this;
    }

    public boolean checkDoublon(String idString, int lineNumber) {
        ParseResult.ResultItem currentResultItem = this.resultItemMap.get(idString);
        if (currentResultItem != null) {
            this.lineLogsBuilder.addMessage("severe.parse", lineNumber, "_ error.existing.tableimport.duplicate", String.valueOf(currentResultItem.getLineNumber()));
            return true;
        }
        return false;
    }

    public ParseResultBuilder addResult(String idString, Object key, Object value, int lineNumber) {
        InternalResultItem resultItem = new InternalResultItem(key, value, lineNumber);
        this.resultItemMap.put(idString, resultItem);
        return this;
    }

    public ParseResultBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    public ParseResult toParseResult() {
        ResultItemList resultItemList = new ResultItemList(this.resultItemMap.values().toArray(new ParseResult.ResultItem[this.resultItemMap.size()]));
        SourceLog initLog = this.columnLogBuilder.toSourceLog();
        LineLogs lineLogs = this.lineLogsBuilder.toLineLogs();
        return new InternalParseResult(this.type, resultItemList, this.path, initLog, lineLogs);
    }

    public static ParseResultBuilder init(String type) {
        return new ParseResultBuilder(type);
    }

    private static class InternalResultItem
    implements ParseResult.ResultItem {
        private final Object keyObject;
        private final Object valueObject;
        private final int lineNumber;

        private InternalResultItem(Object keyObject, Object valueObject, int lineNumber) {
            this.keyObject = keyObject;
            this.valueObject = valueObject;
            this.lineNumber = lineNumber;
        }

        @Override
        public Object getKeyObject() {
            return this.keyObject;
        }

        @Override
        public Object getValueObject() {
            return this.valueObject;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    private static class ResultItemList
    extends AbstractList<ParseResult.ResultItem>
    implements RandomAccess {
        private final ParseResult.ResultItem[] array;

        private ResultItemList(ParseResult.ResultItem[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ParseResult.ResultItem get(int index) {
            return this.array[index];
        }
    }

    private static class InternalParseResult
    implements ParseResult {
        private final String type;
        private final List<ParseResult.ResultItem> resultItemList;
        private final SourceLog initLog;
        private final LineLogs lineLogs;
        private final String path;

        private InternalParseResult(String type, List<ParseResult.ResultItem> resultItemList, String path, SourceLog initLog, LineLogs lineLogs) {
            this.type = type;
            this.resultItemList = resultItemList;
            this.path = path;
            this.initLog = initLog;
            this.lineLogs = lineLogs;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public SourceLog getColumnLog() {
            return this.initLog;
        }

        @Override
        public LineLogs getLineLogs() {
            return this.lineLogs;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<ParseResult.ResultItem> getResultItemList() {
            return this.resultItemList;
        }
    }
}

