/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.catalogs;

import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.AttributeFormatter;

public final class AttributeFormatterCatalog {
    public static final AttributeFormatter VALUE = (attributeValue, valueIndex, formatSource) -> attributeValue;
    public static final AttributeFormatter FORMSYNTAX = new InternalFormSyntax();

    private AttributeFormatterCatalog() {
    }

    private static class InternalFormSyntax
    implements AttributeFormatter {
        private InternalFormSyntax() {
        }

        @Override
        public String formatAttributeValue(String attributeValue, int valueIndex, FormatSource formatSource) {
            int length = attributeValue.length();
            StringBuilder buf = new StringBuilder(length + 20);
            block4: for (int i = 0; i < length; ++i) {
                char carac = attributeValue.charAt(i);
                switch (carac) {
                    case ';': {
                        buf.append("\\;");
                        continue block4;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block4;
                    }
                    default: {
                        buf.append(carac);
                    }
                }
            }
            return buf.toString();
        }
    }
}

