/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.access.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.tools.exportation.access.AccessDefBuilder;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class AccessDefDOMReader {
    private final Fichotheque fichotheque;
    private final AccessDefBuilder accessDefBuilder;
    private final MessageHandler messageHandler;

    public AccessDefDOMReader(Fichotheque fichotheque, AccessDefBuilder accessDefBuilder, MessageHandler messageHandler) {
        this.fichotheque = fichotheque;
        this.accessDefBuilder = accessDefBuilder;
        this.messageHandler = messageHandler;
    }

    public AccessDefDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static AccessDefDOMReader init(Fichotheque fichotheque, AccessDefBuilder accessDefBuilder, MessageHandler messageHandler) {
        return new AccessDefDOMReader(fichotheque, accessDefBuilder, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "public": {
                    AccessDefDOMReader.this.accessDefBuilder.setType("public");
                    break;
                }
                case "tableexport-name": {
                    AccessDefDOMReader.this.accessDefBuilder.setTableExportName(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "type": {
                    AccessDefDOMReader.this.accessDefBuilder.setType(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "token": {
                    AccessDefDOMReader.this.accessDefBuilder.setToken(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "label": 
                case "lib": {
                    try {
                        LabelUtils.readLabel(element, AccessDefDOMReader.this.accessDefBuilder);
                    }
                    catch (ParseException ile) {
                        DomMessages.wrongLangAttribute(AccessDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                default: {
                    if (SelectionDOMUtils.readSelectionOptions(AccessDefDOMReader.this.accessDefBuilder.getSelectionOptionsBuilder(), AccessDefDOMReader.this.fichotheque, element)) break;
                    DomMessages.unknownTagWarning(AccessDefDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }
}

