/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.corpus.FicheContext;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.dom.FicheBlockDOMReader;
import net.fichotheque.tools.dom.FicheItemDOMReader;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FicheChangeDOMReader {
    private final FicheChangeBuilder currentFiche;
    private final FicheContext ficheContext;
    private final RootConsumer rootConsumer = new RootConsumer();
    private final HeadConsumer headConsumer = new HeadConsumer();
    private final BodyConsumer bodyConsumer = new BodyConsumer();
    private final FicheItemDOMReader ficheItemDOMReader;
    private final FicheBlockDOMReader ficheBlockDOMReader;

    public FicheChangeDOMReader(FicheChangeBuilder ficheChangeBuilder, FicheContext ficheContext) {
        this.currentFiche = ficheChangeBuilder;
        this.ficheContext = ficheContext;
        MessageHandler messageHandler = LogUtils.NULL_MESSAGEHANDLER;
        this.ficheBlockDOMReader = new FicheBlockDOMReader(ficheContext.getHtmlCleaner(), messageHandler);
        this.ficheItemDOMReader = new FicheItemDOMReader(this.ficheBlockDOMReader, ficheContext.getFichothequeQuestioner(), messageHandler);
    }

    public void readFiche(Element element) {
        Fiche fiche = new Fiche();
        try {
            Lang lang = Lang.parse(element.getAttribute("xml:lang"));
            fiche.setLang(lang);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        DOMUtils.readChildren(element, this.rootConsumer);
    }

    public boolean readFicheChild(Element element) {
        boolean done = this.headConsumer.readHeadElement(element);
        if (!done) {
            done = this.bodyConsumer.readBodyElement(element);
        }
        return done;
    }

    private void readLang(Element element) {
        String langString = XMLUtils.getData(element);
        if (langString.isEmpty()) {
            this.currentFiche.setLang(null);
        } else {
            try {
                Lang lang = Lang.parse(langString);
                this.currentFiche.setLang(lang);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void readProp(Element element) {
        FieldKey fieldKey;
        String fieldName = element.getAttribute("name");
        if (fieldName.length() == 0) {
            fieldName = element.getAttribute("type");
        }
        if (fieldName.length() == 0) {
            return;
        }
        try {
            fieldKey = FieldKey.parse((short)1, fieldName);
        }
        catch (ParseException pe) {
            return;
        }
        FicheItem ficheItem = null;
        NodeList liste = element.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            if (liste.item(j).getNodeType() != 1) continue;
            Element el = (Element)liste.item(j);
            ficheItem = this.ficheItemDOMReader.readFicheItem(el);
            break;
        }
        this.currentFiche.setProp(fieldKey, ficheItem);
    }

    public void readInfo(Element element) {
        FieldKey fieldKey;
        String fieldName = element.getAttribute("name");
        if (fieldName.length() == 0) {
            fieldName = element.getAttribute("type");
        }
        if (fieldName.length() == 0) {
            return;
        }
        try {
            fieldKey = FieldKey.parse((short)2, fieldName);
        }
        catch (ParseException pe) {
            return;
        }
        FicheItems ficheItems = this.readFicheItems(element);
        this.currentFiche.appendInfo(fieldKey, ficheItems);
    }

    public void readOwners(Element element) {
        FicheItems ficheItems = this.readFicheItems(element);
        this.currentFiche.appendOwners(ficheItems);
    }

    public void readSection(Element element) {
        FieldKey fieldKey;
        String fieldName = element.getAttribute("name");
        if (fieldName.length() == 0) {
            fieldName = element.getAttribute("type");
        }
        try {
            fieldKey = FieldKey.parse((short)3, fieldName);
        }
        catch (ParseException pe) {
            return;
        }
        List<FicheBlock> list = this.ficheBlockDOMReader.readFicheBlockList(element);
        FicheBlocks ficheBlocks = FicheUtils.toFicheBlocks(list);
        this.currentFiche.appendSection(fieldKey, ficheBlocks);
    }

    private FicheItems readFicheItems(Element element) {
        ArrayList<FicheItem> list = new ArrayList<FicheItem>();
        NodeList liste = element.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            Element child;
            FicheItem ficheItem;
            if (liste.item(j).getNodeType() != 1 || (ficheItem = this.ficheItemDOMReader.readFicheItem(child = (Element)liste.item(j))) == null) continue;
            try {
                list.add(ficheItem);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return FicheUtils.toFicheItems(list);
    }

    private class BodyConsumer
    implements Consumer<Element> {
        private BodyConsumer() {
        }

        @Override
        public void accept(Element element) {
            this.readBodyElement(element);
        }

        private boolean readBodyElement(Element element) {
            switch (element.getTagName()) {
                case "texte": {
                    FieldKey fieldKey = FieldKey.build((short)3, "texte");
                    List<FicheBlock> list = FicheChangeDOMReader.this.ficheBlockDOMReader.readFicheBlockList(element);
                    FicheBlocks ficheBlocks = FicheUtils.toFicheBlocks(list);
                    FicheChangeDOMReader.this.currentFiche.appendSection(fieldKey, ficheBlocks);
                    return true;
                }
                case "section": 
                case "annexe": {
                    FicheChangeDOMReader.this.readSection(element);
                    return true;
                }
            }
            return false;
        }
    }

    private class HeadConsumer
    implements Consumer<Element> {
        private HeadConsumer() {
        }

        @Override
        public void accept(Element element) {
            this.readHeadElement(element);
        }

        private boolean readHeadElement(Element element) {
            switch (element.getTagName()) {
                case "title": 
                case "titre": {
                    FicheChangeDOMReader.this.currentFiche.setTitle(CleanedString.newInstance(XMLUtils.getData(element)));
                    return true;
                }
                case "subtitle": 
                case "soustitre": {
                    FicheChangeDOMReader.this.currentFiche.setSubtitle(FicheChangeDOMReader.this.ficheItemDOMReader.readPara(element));
                    return true;
                }
                case "prop": 
                case "propriete": {
                    FicheChangeDOMReader.this.readProp(element);
                    return true;
                }
                case "info": 
                case "information": {
                    FicheChangeDOMReader.this.readInfo(element);
                    return true;
                }
                case "owners": 
                case "redacteurs": {
                    FicheChangeDOMReader.this.readOwners(element);
                    return true;
                }
                case "lang": {
                    FicheChangeDOMReader.this.readLang(element);
                    return true;
                }
            }
            return false;
        }
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            switch (element.getTagName()) {
                case "head": 
                case "entete": 
                case "source": {
                    DOMUtils.readChildren(element, FicheChangeDOMReader.this.headConsumer);
                    break;
                }
                case "body": 
                case "corpsdefiche": {
                    DOMUtils.readChildren(element, FicheChangeDOMReader.this.bodyConsumer);
                }
            }
        }
    }
}

