/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.filesupload;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadResult;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadUtils;
import fr.exemole.bdfserver.tools.filesupload.TmpFileGroup;
import fr.exemole.bdfserver.tools.filesupload.TmpFileInfo;
import fr.exemole.bdfserver.tools.filesupload.UploadError;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.utils.AddendaUtils;
import net.mapeadores.util.primitives.FileLength;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.text.FileName;

public final class FilesUploadEngine {
    public static final String UNIQUE_MODE = "unique";
    public static final String MULTI_MODE = "multi";
    private static final FileName DEFAULT_FILENAME = FileName.build("file.octetstream");
    private final BdfServer bdfServer;
    private final ResultBuilder resultBuilder;

    private FilesUploadEngine(BdfServer bdfServer, ResultBuilder resultBuilder) {
        this.bdfServer = bdfServer;
        this.resultBuilder = resultBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileUpload(FileValue fileValue) throws IOException {
        File tmpFile;
        if (fileValue.length() < 1L) {
            fileValue.free();
            return;
        }
        String extension = this.resultBuilder.setCurrent(fileValue.getName());
        try {
            tmpFile = FilesUploadUtils.saveTmpFile(this.bdfServer, fileValue, extension);
        }
        finally {
            fileValue.free();
        }
        this.resultBuilder.addTmpFile(tmpFile.getName(), new FileLength(tmpFile.length()));
    }

    public FilesUploadResult getResult() {
        return this.resultBuilder.getResult();
    }

    public static String checkMode(String mode) {
        switch (mode) {
            case "unique": {
                return UNIQUE_MODE;
            }
            case "multi": {
                return MULTI_MODE;
            }
        }
        throw new IllegalArgumentException("Unknown mode");
    }

    public static FilesUploadEngine newInstance(BdfServer bdfServer, String mode) {
        switch (mode) {
            case "unique": {
                return new FilesUploadEngine(bdfServer, new UniqueResultBuilder());
            }
            case "multi": {
                return new FilesUploadEngine(bdfServer, new MultiResultBuilder());
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + mode);
    }

    private static abstract class ResultBuilder {
        protected String current;
        protected String currentExtension;
        protected String currentOriginalBasename;
        protected String currentNormalizedBasename;

        protected ResultBuilder() {
        }

        public abstract FilesUploadResult getResult();

        private String setCurrent(String current) {
            FileName fileName;
            this.current = current;
            try {
                fileName = FileName.parse(current, "octetstream");
            }
            catch (ParseException pe) {
                fileName = DEFAULT_FILENAME;
            }
            this.currentExtension = fileName.getExtension().toLowerCase();
            if (!AddendaUtils.testExtension(this.currentExtension)) {
                this.currentExtension = "octetstream";
            }
            this.currentOriginalBasename = fileName.getBasename();
            this.currentNormalizedBasename = AddendaUtils.checkNormalization(this.currentOriginalBasename);
            return this.currentExtension;
        }

        protected void addTmpFile(String tmpFileName, FileLength tmpFileLength) {
            this.addTmpFileInfo(new TmpFileInfo(this.currentExtension, tmpFileName, this.currentOriginalBasename, this.currentNormalizedBasename));
        }

        protected abstract void addTmpFileInfo(TmpFileInfo var1);
    }

    private static class UniqueResultBuilder
    extends ResultBuilder {
        private final Map<String, TmpFileInfo> extensionMap = new LinkedHashMap<String, TmpFileInfo>();
        private final List<UploadError> uploadErrorList = new ArrayList<UploadError>();

        private UniqueResultBuilder() {
        }

        @Override
        public FilesUploadResult getResult() {
            List<TmpFileInfo> list = FilesUploadUtils.wrap(this.extensionMap.values().toArray(new TmpFileInfo[this.extensionMap.size()]));
            return new FilesUploadResult.Unique(list, this.uploadErrorList);
        }

        @Override
        protected void addTmpFileInfo(TmpFileInfo tmpFileInfo) {
            String extension = tmpFileInfo.getExtension();
            if (!this.extensionMap.containsKey(extension)) {
                this.extensionMap.put(extension, tmpFileInfo);
            } else {
                this.uploadErrorList.add(UploadError.build(tmpFileInfo, "_ error.unsupported.extensionrepeated", extension));
            }
        }
    }

    private static class MultiResultBuilder
    extends ResultBuilder {
        private final SortedMap<String, TmpFileGroup> groupMap = new TreeMap<String, TmpFileGroup>();
        private final List<UploadError> uploadErrorList = new ArrayList<UploadError>();

        private MultiResultBuilder() {
        }

        @Override
        public FilesUploadResult getResult() {
            List<TmpFileGroup> groupList = FilesUploadUtils.wrap(this.groupMap.values().toArray(new TmpFileGroup[this.groupMap.size()]));
            return new FilesUploadResult.Multi(groupList, this.uploadErrorList);
        }

        @Override
        protected void addTmpFileInfo(TmpFileInfo tmpFileInfo) {
            String originalBaseName = tmpFileInfo.getOriginalBasename();
            TmpFileGroup currentGroup = (TmpFileGroup)this.groupMap.get(originalBaseName);
            if (currentGroup == null) {
                currentGroup = new TmpFileGroup(tmpFileInfo);
                this.groupMap.put(originalBaseName, currentGroup);
            } else if (currentGroup.containsExtension(tmpFileInfo.getExtension())) {
                this.uploadErrorList.add(UploadError.build(tmpFileInfo, "_ error.unsupported.filerepeated", tmpFileInfo.getOriginalBasename() + "." + tmpFileInfo.getExtension()));
            } else {
                currentGroup.addTmpFileInfo(tmpFileInfo);
            }
        }
    }
}

