/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders.thesaurus;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.include.SubsetItemValue;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Liaison;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.text.StringUtils;

class MotcleValueListBuilder {
    private final List<SubsetItemValue> valueList = new ArrayList<SubsetItemValue>();

    MotcleValueListBuilder() {
    }

    boolean isEmpty() {
        return this.valueList.isEmpty();
    }

    void add(Motcle motcle, int weight) {
        String idalpha = motcle.getIdalpha();
        String value = idalpha != null ? idalpha : String.valueOf(motcle.getId());
        if (weight > 1) {
            value = value + "<" + weight + ">";
        }
        this.valueList.add(FicheFormUtils.toSubsetItemValue(value, weight, motcle));
    }

    void populateDefault(FicheFormParameters ficheFormParameters, IncludeUi includeUi, Thesaurus thesaurus) {
        String defaultValue = FicheFormUtils.getDefVal(ficheFormParameters, includeUi);
        if (defaultValue.length() == 0) {
            return;
        }
        String[] tokens = StringUtils.getTokens(defaultValue, ';', (short)2);
        HashSet<Motcle> defaultSet = new HashSet<Motcle>();
        boolean withIdalpha = thesaurus.isIdalphaType();
        for (String token : tokens) {
            if (withIdalpha) {
                Motcle motcle = thesaurus.getMotcleByIdalpha(token);
                if (motcle == null || defaultSet.contains(motcle)) continue;
                defaultSet.add(motcle);
                this.add(motcle, -1);
                continue;
            }
            try {
                int motcleid = Integer.parseInt(token);
                Motcle motcle = thesaurus.getMotcleById(motcleid);
                if (motcle == null || defaultSet.contains(motcle)) continue;
                defaultSet.add(motcle);
                this.add(motcle, -1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    Collection<Liaison> populate(Junctions motcleJunctions, SubsetIncludeUi includeUi, boolean withWeight) {
        ExtendedIncludeKey extendedIncludeKey = includeUi.getExtendedIncludeKey();
        Collection<Liaison> liaisons = JunctionUtils.filter(motcleJunctions, extendedIncludeKey);
        if (!withWeight || extendedIncludeKey.hasWeightFilter()) {
            for (Liaison liaison : liaisons) {
                this.add((Motcle)liaison.getSubsetItem(), -1);
            }
        } else {
            for (Liaison liaison : liaisons) {
                this.add((Motcle)liaison.getSubsetItem(), liaison.getTie().getWeight());
            }
        }
        return liaisons;
    }

    List<SubsetItemValue> toList() {
        return FicheFormUtils.wrap(this.valueList.toArray(new SubsetItemValue[this.valueList.size()]));
    }
}

