/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.configuration.dom;

import fr.exemole.bdfserver.tools.configuration.LangConfigurationBuilder;
import java.text.ParseException;
import java.util.function.Consumer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class LangConfigurationDOMReader {
    private final LangConfigurationBuilder langConfigurationBuilder;
    private final MessageHandler messageHandler;

    public LangConfigurationDOMReader(LangConfigurationBuilder langConfigurationBuilder, MessageHandler messageHandler) {
        this.langConfigurationBuilder = langConfigurationBuilder;
        this.messageHandler = messageHandler;
    }

    public void readLangConfiguration(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("all-languages")) {
                LangConfigurationDOMReader.this.langConfigurationBuilder.setAllLanguages(true);
            } else if (tagName.equals("with-nonlatin") || tagName.equals("with-original-name")) {
                LangConfigurationDOMReader.this.langConfigurationBuilder.setWithNonlatin(true);
            } else if (tagName.equals("working-lang")) {
                try {
                    Lang lang = Lang.parse(element.getAttribute("lang"));
                    LangConfigurationDOMReader.this.langConfigurationBuilder.addWorkingLang(lang);
                }
                catch (ParseException lang) {}
            } else if (tagName.equals("supplementary-lang")) {
                try {
                    Lang lang = Lang.parse(element.getAttribute("lang"));
                    LangConfigurationDOMReader.this.langConfigurationBuilder.addSupplementaryLang(lang);
                }
                catch (ParseException parseException) {}
            } else if (tagName.equals("without-surname-first") || tagName.equals("without-nom-avant")) {
                LangConfigurationDOMReader.this.langConfigurationBuilder.setWithoutSurnameFirst(true);
            } else {
                DomMessages.unknownTagWarning(LangConfigurationDOMReader.this.messageHandler, tagName);
            }
        }
    }
}

