/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.text.AccoladeArgument;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.ValueResolver;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class PathConfigurationBuilder {
    private static final String SEVERE = "severe";
    private static final String WARNING = "warning";
    private static final String INFO = "info";
    private static final String TARGET_PREFIX = "target.";
    private static final RelativePath PUB_PATH = RelativePath.build("pub");
    private final BdfServer bdfServer;
    private final SortedMap<String, File> targetMap = new TreeMap<String, File>();
    private final MultiMessageHandler messageHandler;
    private File publicDirectory;
    private String publicUrlRoot;

    private PathConfigurationBuilder(BdfServer bdfServer, MultiMessageHandler messageHandler) {
        this.bdfServer = bdfServer;
        this.messageHandler = messageHandler;
    }

    private PathConfiguration toPathConfiguration() {
        if (this.publicDirectory == null || !this.publicDirectory.exists()) {
            this.publicDirectory = this.bdfServer.getOutputStorage().getFile(PUB_PATH);
            this.publicDirectory.mkdirs();
            this.publicUrlRoot = null;
        }
        if (this.publicUrlRoot == null) {
            this.publicUrlRoot = "pub/";
        }
        return new InternalPathConfiguration(this.publicDirectory, this.publicUrlRoot, this.targetMap);
    }

    public static PathConfiguration build(BdfServer bdfServer) {
        return PathConfigurationBuilder.build(bdfServer, null);
    }

    public static PathConfiguration build(BdfServer bdfServer, @Nullable MultiMessageHandler messageHandler) {
        if (messageHandler == null) {
            messageHandler = LogUtils.NULL_MULTIMESSAGEHANDLER;
        }
        PathConfigurationBuilder builder = new PathConfigurationBuilder(bdfServer, messageHandler);
        builder.readOldOutputConfiguration();
        builder.readPathsIni();
        return builder.toPathConfiguration();
    }

    private void readOldOutputConfiguration() {
        File oldXml = this.bdfServer.getBdfServerDirs().getSubPath("var.data", "bdfdata/conf/output-configuration.xml");
        if (oldXml.exists()) {
            this.messageHandler.setCurrentSource(oldXml.getPath());
            this.messageHandler.addMessage(INFO, "_ info.configuration.oldouputconfiguration", new Object[0]);
            Document document = DOMUtils.readDocument(oldXml);
            DOMUtils.readChildren(document.getDocumentElement(), new OldOutputConfigurationConsumer());
        }
    }

    private void readPathsIni() {
        FileInputStream is;
        BdfServerDirs dirs = this.bdfServer.getBdfServerDirs();
        File pathsIni = dirs.getSubPath("etc.config", "paths.ini");
        File defaultPathsIni = dirs.getSubPath("etc.config.default", "paths.ini");
        HashMap<String, String> map = new HashMap<String, String>();
        if (defaultPathsIni.exists() && !defaultPathsIni.equals(pathsIni)) {
            this.messageHandler.setCurrentSource(defaultPathsIni.getPath());
            try {
                is = new FileInputStream(defaultPathsIni);
                try {
                    IniParser.parseIni((InputStream)is, map);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ioe) {
                this.messageHandler.addMessage(SEVERE, "_ error.exception.io", ioe.getLocalizedMessage());
            }
        }
        if (pathsIni.exists()) {
            this.messageHandler.setCurrentSource(pathsIni.getPath());
            try {
                is = new FileInputStream(pathsIni);
                try {
                    IniParser.parseIni((InputStream)is, map);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ioe) {
                this.messageHandler.addMessage(SEVERE, "_ error.exception.io", ioe.getLocalizedMessage());
            }
        }
        block28: for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = this.checkValue((String)entry.getValue());
            if (key.startsWith(TARGET_PREFIX)) {
                String targetName = key.substring(TARGET_PREFIX.length());
                if (StringUtils.isTechnicalName(targetName, true)) {
                    try {
                        File targetDir = ConfigurationUtils.toDirectory(value);
                        this.targetMap.put(targetName, targetDir);
                    }
                    catch (FileNotFoundException fnne) {
                        this.messageHandler.addMessage(SEVERE, "_ error.unknown.directory", value);
                    }
                    continue;
                }
                this.messageHandler.addMessage(SEVERE, "_ error.wrong.parametername", key);
                continue;
            }
            switch (key) {
                case "public_path": {
                    try {
                        this.publicDirectory = ConfigurationUtils.toDirectory(value);
                    }
                    catch (FileNotFoundException fnne) {
                        this.messageHandler.addMessage(SEVERE, "_ error.unknown.directory", value);
                    }
                    continue block28;
                }
                case "public_url": {
                    try {
                        this.publicUrlRoot = ConfigurationUtils.checkURL(value);
                    }
                    catch (MalformedURLException mue) {
                        this.messageHandler.addMessage(SEVERE, "_ error.wrong.url", value);
                    }
                    continue block28;
                }
            }
            this.messageHandler.addMessage(WARNING, "_ error.unknown.parametername", key);
        }
    }

    private String checkValue(String value) {
        try {
            AccoladePattern accoladePattern = new AccoladePattern(value);
            return accoladePattern.format(new InternalValueResolver());
        }
        catch (ParseException pe) {
            return value;
        }
    }

    private static class InternalPathConfiguration
    implements PathConfiguration {
        private final File publicDirectory;
        private final String publicUrlRoot;
        private final SortedMap<String, File> targetMap;

        private InternalPathConfiguration(File publicDirectory, String publicUrlRoot, SortedMap<String, File> targetMap) {
            this.publicDirectory = publicDirectory;
            this.publicUrlRoot = publicUrlRoot;
            this.targetMap = targetMap;
        }

        @Override
        public String getPublicUrl(String path) {
            return this.publicUrlRoot + path;
        }

        @Override
        public File getTargetDirectory(String name) {
            if (name.equals("_public")) {
                return this.publicDirectory;
            }
            return (File)this.targetMap.get(name);
        }

        @Override
        public Set<String> getTargetNameSet() {
            return Collections.unmodifiableSet(this.targetMap.keySet());
        }
    }

    private class OldOutputConfigurationConsumer
    implements Consumer<Element> {
        private OldOutputConfigurationConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("path")) {
                String name = element.getAttribute("name");
                if (name.equals("output._pub")) {
                    String publicValue = element.getAttribute("public");
                    String systemValue = element.getAttribute("system");
                    if (publicValue.length() > 0) {
                        try {
                            PathConfigurationBuilder.this.publicUrlRoot = ConfigurationUtils.checkURL(publicValue);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (systemValue.length() > 0) {
                        try {
                            PathConfigurationBuilder.this.publicDirectory = ConfigurationUtils.toDirectory(systemValue);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                } else if (name.startsWith("root.")) {
                    String rootName = name.substring(5);
                    String systemValue = element.getAttribute("system");
                    if (systemValue.length() > 0) {
                        try {
                            File dir = ConfigurationUtils.toDirectory(systemValue);
                            if (dir != null) {
                                PathConfigurationBuilder.this.targetMap.put(rootName, dir);
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private class InternalValueResolver
    implements ValueResolver {
        private InternalValueResolver() {
        }

        @Override
        public String getValue(AccoladeArgument accoladeArgument) {
            File dir;
            String name = accoladeArgument.getName();
            if (name.equals("name")) {
                return PathConfigurationBuilder.this.bdfServer.getBdfServerDirs().getName();
            }
            if (name.startsWith("custom.") && (dir = PathConfigurationBuilder.this.bdfServer.getBdfServerDirs().getDir(name)) != null) {
                return dir.getPath();
            }
            PathConfigurationBuilder.this.messageHandler.addMessage(name, "_ error.unknown.pattern", name);
            return "__" + name + "__";
        }
    }
}

