/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine.runners;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.balayage.BdfBalayageUtils;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.balayage.engine.EngineUtils;
import fr.exemole.bdfserver.tools.balayage.engine.runners.AbstractBalayageUnitRunner;
import fr.exemole.bdfserver.tools.balayage.engine.runners.TransformOutputRunner;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.balayage.BalayageMode;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.fichotheque.extraction.ExtractionSource;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.extraction.run.CorpusExtractResult;
import net.fichotheque.extraction.run.ThesaurusExtractResult;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.MotcleSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.tools.extraction.ExtractionEngine;
import net.fichotheque.tools.extraction.ExtractionEngineUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.fichotheque.utils.selection.MotcleSelectorBuilder;
import net.fichotheque.utils.selection.SelectionContextBuilder;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.text.ValueResolver;
import org.xml.sax.SAXException;

public class TransformBalayageUnitRunner
extends AbstractBalayageUnitRunner {
    private final BalayageDescription balayageDescription;
    private final BalayageDef balayageDef;
    private TransformOutputRunner[] outputRunnerArray;
    private ExtractionDef extractionDef;
    private boolean testCurrentDate = false;
    private final InternalExtractionSource internalExtractionSource;

    public TransformBalayageUnitRunner(BalayageParameters balayageParameters, int balayageIndex, BalayageUnit balayageUnit) {
        super(balayageParameters, balayageIndex, balayageUnit);
        BalayageMode balayageMode;
        this.balayageDescription = balayageParameters.getBalayageDescription();
        BdfServer bdfServer = balayageParameters.getBdfServer();
        this.balayageDef = balayageParameters.getBalayageDef();
        ArrayList<TransformOutputRunner> outputList = new ArrayList<TransformOutputRunner>();
        int p = 0;
        for (BalayageOutput output : balayageUnit.getOutputList()) {
            TransformOutputRunner outputRunner = new TransformOutputRunner(balayageParameters, p, output, balayageIndex);
            if (!outputRunner.isValid()) continue;
            outputList.add(outputRunner);
            ++p;
        }
        this.outputRunnerArray = outputList.toArray(new TransformOutputRunner[outputList.size()]);
        String type = balayageUnit.getType();
        String extractionPath = balayageUnit.getExtractionPath();
        if (!extractionPath.isEmpty()) {
            try {
                this.extractionDef = BdfBalayageUtils.getExtractionDef(bdfServer, this.balayageDescription, extractionPath);
                if (this.extractionDef == null) {
                    this.balayageLog.addBalayageUnitError(balayageIndex, balayageUnit, "extractionNotFound", extractionPath, null);
                }
            }
            catch (SAXException ube) {
                this.balayageLog.addBalayageUnitError(balayageIndex, balayageUnit, "extractionException", extractionPath, ube.getMessage());
            }
        }
        if (this.extractionDef == null) {
            this.extractionDef = BdfBalayageUtils.getDefaultExtractionDef(balayageUnit.getType());
        }
        List<CorpusExtractResult> corpusExtractResultList = ExtractionEngineUtils.runCorpusExtractDef(this.extractionDef.getStaticCorpusExtractDefList(), this.extractionContext, balayageParameters.getSelectedFiches());
        List<ThesaurusExtractResult> thesaurusExtractResultList = ExtractionEngineUtils.runThesaurusExtractDef(this.extractionDef.getStaticThesaurusExtractDefList(), this.extractionContext);
        this.internalExtractionSource = new InternalExtractionSource(corpusExtractResultList, thesaurusExtractResultList);
        if (type.equals("fiche") && (balayageMode = balayageParameters.getBalayageMode()) != null && balayageMode.isWithCurrentDateLimit()) {
            this.testCurrentDate = true;
        }
    }

    @Override
    protected boolean isEmpty() {
        return this.outputRunnerArray.length == 0;
    }

    @Override
    protected void run(String balayageUnitType) {
        switch (balayageUnitType) {
            case "corpus": {
                this.runCorpusBalayage();
                break;
            }
            case "fiche": {
                this.runFicheBalayage();
                break;
            }
            case "motcle": {
                this.runMotcleBalayage();
                break;
            }
            case "thesaurus": {
                this.runThesaurusBalayage();
                break;
            }
            case "unique": {
                this.runUniqueBalayage();
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (int i = 0; i < this.outputRunnerArray.length; ++i) {
            this.outputRunnerArray[i].dispose();
            this.outputRunnerArray[i] = null;
        }
        this.outputRunnerArray = null;
        this.extractionDef = null;
    }

    private void runCorpusBalayage() {
        Corpus[] corpusArray;
        for (Corpus corpus : corpusArray = SelectionUtils.toCorpusArray(this.fichotheque, this.balayageUnit.getFicheQuery(), this.extractionContext.getSubsetAccessPredicate())) {
            this.internalExtractionSource.setDynamicObject(corpus);
            String extractionString = this.getExtractionString();
            ValueResolver patternValueSet = EngineUtils.getValueResolver(corpus);
            for (TransformOutputRunner outputRunner : this.outputRunnerArray) {
                outputRunner.write(corpus, patternValueSet, extractionString);
            }
        }
    }

    private void runFicheBalayage() {
        FicheQuery ficheQuery = this.balayageUnit.getFicheQuery();
        Fiches fichePredicate = this.balayageUnit.isGlobalSelect() ? this.balayageParameters.getSelectedFiches() : null;
        SelectionContext selectionContext = SelectionContextBuilder.build(this.extractionContext, this.defaultWorkingLang).setSubsetAccessPredicate(this.extractionContext.getSubsetAccessPredicate()).setFichePredicate(fichePredicate).toSelectionContext();
        FicheSelector ficheSelector = FicheSelectorBuilder.init(selectionContext).add(ficheQuery).toFicheSelector();
        Fiches fiches = FichesBuilder.build("id-asc").populate(ficheSelector).toFiches();
        for (Fiches.Entry entry : fiches.getEntryList()) {
            FuzzyDate currentDate = FuzzyDate.current();
            for (FicheMeta ficheMeta : entry.getFicheMetaList()) {
                if (this.testCurrentDate && FuzzyDate.compare(ficheMeta.getModificationDate(), currentDate) != 0) continue;
                this.internalExtractionSource.setDynamicObject(ficheMeta);
                String extractionString = this.getExtractionString();
                ValueResolver patternValueSet = EngineUtils.getValueResolver(ficheMeta);
                for (TransformOutputRunner outputRunner : this.outputRunnerArray) {
                    outputRunner.write(ficheMeta, patternValueSet, extractionString);
                }
            }
        }
    }

    private void runUniqueBalayage() {
        this.internalExtractionSource.setDynamicObject(null);
        String extractionString = this.getExtractionString();
        ValueResolver patternValueSet = EngineUtils.getValueResolver(null);
        for (TransformOutputRunner outputRunner : this.outputRunnerArray) {
            outputRunner.write(null, patternValueSet, extractionString);
        }
    }

    private void runThesaurusBalayage() {
        Thesaurus[] thesaurusArray;
        for (Thesaurus thesaurus : thesaurusArray = SelectionUtils.toThesaurusArray(this.fichotheque, this.balayageUnit.getMotcleQuery(), this.extractionContext.getSubsetAccessPredicate())) {
            this.internalExtractionSource.setDynamicObject(thesaurus);
            String extractionString = this.getExtractionString();
            ValueResolver patternValueSet = EngineUtils.getValueResolver(thesaurus);
            for (TransformOutputRunner outputRunner : this.outputRunnerArray) {
                outputRunner.write(thesaurus, patternValueSet, extractionString);
            }
        }
    }

    private void runMotcleBalayage() {
        SelectionContext selectionContext = SelectionContextBuilder.build(this.extractionContext, this.defaultWorkingLang).setSubsetAccessPredicate(this.extractionContext.getSubsetAccessPredicate()).toSelectionContext();
        MotcleSelector motcleSelector = MotcleSelectorBuilder.init(selectionContext).add(this.balayageUnit.getMotcleQuery(), null).toMotcleSelector();
        for (Thesaurus thesaurus : motcleSelector.getThesaurusList()) {
            for (Motcle motcle : thesaurus.getMotcleList()) {
                if (!motcleSelector.test(motcle)) continue;
                this.writeMotcle(motcle);
            }
        }
    }

    private void writeMotcle(Motcle motcle) {
        this.internalExtractionSource.setDynamicObject(motcle);
        String extractionString = this.getExtractionString();
        ValueResolver patternValueSet = EngineUtils.getValueResolver(motcle);
        for (TransformOutputRunner outputRunner : this.outputRunnerArray) {
            outputRunner.write(motcle, patternValueSet, extractionString);
        }
    }

    private String getExtractionString() {
        return ExtractionEngine.init(this.extractParameters, this.extractionDef).prettyXml(this.balayageDef.ignoreTransformation()).run(this.internalExtractionSource);
    }

    private static class InternalExtractionSource
    implements ExtractionSource {
        private final List<CorpusExtractResult> corpusExtractResultList;
        private final List<ThesaurusExtractResult> thesaurusExtractResultList;
        private Object dynamicObject;

        private InternalExtractionSource(List<CorpusExtractResult> corpusExtractorList, List<ThesaurusExtractResult> thesaurusExtractResultList) {
            this.corpusExtractResultList = corpusExtractorList;
            this.thesaurusExtractResultList = thesaurusExtractResultList;
        }

        @Override
        public Object getDynamicObject() {
            return this.dynamicObject;
        }

        private void setDynamicObject(Object dynamicObject) {
            this.dynamicObject = dynamicObject;
        }

        @Override
        public List<CorpusExtractResult> getStaticCorpusExtractResultList() {
            return this.corpusExtractResultList;
        }

        @Override
        public List<ThesaurusExtractResult> getStaticThesaurusExtractResultList() {
            return this.thesaurusExtractResultList;
        }
    }
}

