/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import net.mapeadores.util.date.FuzzyDate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ChronoDOMReader {
    ChronoDOMReader() {
    }

    void migrateChrono(File currentCorpusDir, Element element_xml) throws IOException {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Object[] array;
            Element el;
            String tagname;
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1 || !(tagname = (el = (Element)nd).getTagName()).equals("ch") || (array = this.getArray(el)) == null) continue;
            int ficheid = (Integer)array[0];
            File millierDir = new File(currentCorpusDir, "f." + BdfServerUtils.getMillier(ficheid));
            if (!millierDir.exists()) continue;
            String idString = String.valueOf(ficheid);
            File ficheDir = new File(millierDir, idString);
            File ficheFile = new File(millierDir, idString + ".xml");
            if (!ficheDir.exists() && !ficheFile.exists()) continue;
            ficheDir.mkdir();
            File chrono = new File(ficheDir, "chrono.txt");
            FuzzyDate creationDate = (FuzzyDate)array[1];
            FuzzyDate modificationDate = (FuzzyDate)array[2];
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(chrono), "UTF-8"));){
                if (creationDate == null) continue;
                writer.write(creationDate.toString());
                if (FuzzyDate.compare(modificationDate, creationDate) <= 0) continue;
                writer.write("\n");
                writer.write(modificationDate.toString());
                continue;
            }
        }
    }

    private Object[] getArray(Element element_xml) {
        FuzzyDate creationDate;
        int id;
        String idString = element_xml.getAttribute("id");
        if (idString.length() == 0) {
            return null;
        }
        try {
            id = Integer.parseInt(idString);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        String creationDateString = element_xml.getAttribute("c");
        if (creationDateString.length() == 0) {
            return null;
        }
        try {
            creationDate = FuzzyDate.parse(creationDateString);
        }
        catch (ParseException ide) {
            return null;
        }
        FuzzyDate modificationDate = null;
        String modificationDateString = element_xml.getAttribute("m");
        if (modificationDateString.length() > 0) {
            try {
                modificationDate = FuzzyDate.parse(modificationDateString);
            }
            catch (ParseException e) {
                return null;
            }
        }
        Object[] result = new Object[]{id, creationDate, modificationDate};
        return result;
    }
}

