/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.jdbm;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.storage.directory.jdbm.CorpsFiche;
import fr.exemole.bdfserver.storage.directory.jdbm.CorpsFicheSerializer;
import fr.exemole.bdfserver.storage.directory.jdbm.EnteteFiche;
import fr.exemole.bdfserver.storage.directory.jdbm.EnteteFicheSerializer;
import fr.exemole.bdfserver.storage.directory.jdbm.FieldKeyCoder;
import fr.exemole.bdfserver.storage.directory.jdbm.SubsetItemRecordId;
import fr.exemole.bdfserver.storage.directory.jdbm.SubsetItemRecordIdMap;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import jdbm.RecordManager;
import jdbm.helper.Serializer;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;

public class FichothequeJdbm {
    private static final long JDBM_VERSION = 6L;
    private static final String FIELDKEY_CODER_NAME = "fieldkey_coder";
    private static final String SUBSETITEM_RECORDID_MAP_NAME = "subsetitem_recordid_map";
    private final FieldKeyCoder fieldKeyCoder;
    private final SubsetItemRecordIdMap subsetItemRecordIdMap;
    private final EnteteFicheSerializer enteteFicheSerializer;
    private final CorpsFicheSerializer corpsFicheSerializer;
    private RecordManager recordManager;
    private int commitCounter = 0;

    private FichothequeJdbm(RecordManager recordManager) throws IOException {
        this.recordManager = recordManager;
        this.fieldKeyCoder = FieldKeyCoder.init(recordManager, FIELDKEY_CODER_NAME);
        this.subsetItemRecordIdMap = SubsetItemRecordIdMap.init(recordManager, SUBSETITEM_RECORDID_MAP_NAME);
        this.enteteFicheSerializer = new EnteteFicheSerializer(this.fieldKeyCoder);
        this.corpsFicheSerializer = new CorpsFicheSerializer(this.fieldKeyCoder);
    }

    public void setRecordManager(RecordManager recordManager) {
        this.recordManager = recordManager;
    }

    public static FichothequeJdbm checkJdbmVersion(RecordManager recordManager) {
        try {
            long recordId = recordManager.getNamedObject("fichotheque_jdbm_version");
            if (recordId == 0L) {
                return null;
            }
            Object obj = recordManager.fetch(recordId);
            if (!(obj instanceof Long)) {
                return null;
            }
            long l = (Long)obj;
            if (l != 6L) {
                return null;
            }
            return new FichothequeJdbm(recordManager);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public static FichothequeJdbm initEmptyInstance(RecordManager recordManager) {
        try {
            long recordId = recordManager.insert((Object)6L);
            recordManager.setNamedObject("fichotheque_jdbm_version", recordId);
            recordManager.commit();
            return new FichothequeJdbm(recordManager);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public Fiche getFiche(FicheMeta ficheMeta, boolean ficheComplete) {
        try {
            if (ficheComplete) {
                return this.getFicheComplete(ficheMeta);
            }
            EnteteFiche enteteFiche = this.getEnteteFiche(ficheMeta);
            return enteteFiche.getFiche();
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public void removeFiche(Corpus corpus, int id) {
        try {
            SubsetItemRecordId recordId = this.subsetItemRecordIdMap.removeSubsetItem(corpus, id);
            if (recordId == null) {
                return;
            }
            this.recordManager.delete(recordId.getRecid1());
            if (recordId.getType() == 2) {
                this.recordManager.delete(recordId.getRecid2());
            }
            this.testIntermediateCommit();
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public void updateFiche(FicheMeta ficheMeta, FicheAPI fiche) {
        int ficheid = ficheMeta.getId();
        EnteteFicheSerializer.Input enteteInput = new EnteteFicheSerializer.Input(ficheid, fiche);
        CorpsFicheSerializer.Input corpsInput = new CorpsFicheSerializer.Input(fiche);
        try {
            SubsetItemRecordId recordIdObject = this.subsetItemRecordIdMap.getRecordId(ficheMeta);
            if (recordIdObject == null) {
                long recid1 = this.recordManager.insert((Object)enteteInput, (Serializer)this.enteteFicheSerializer);
                long recid2 = this.recordManager.insert((Object)corpsInput, (Serializer)this.corpsFicheSerializer);
                this.subsetItemRecordIdMap.add(ficheMeta.getCorpus(), ficheid, recid1, recid2);
            } else {
                long recid1 = recordIdObject.getRecid1();
                this.recordManager.update(recid1, (Object)enteteInput, (Serializer)this.enteteFicheSerializer);
                long recid2 = recordIdObject.getRecid2();
                this.recordManager.update(recid2, (Object)corpsInput, (Serializer)this.corpsFicheSerializer);
            }
            this.testIntermediateCommit();
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public void commitChanges() {
        try {
            if (this.subsetItemRecordIdMap.isWithChange()) {
                this.subsetItemRecordIdMap.save(this.recordManager, SUBSETITEM_RECORDID_MAP_NAME);
            }
            if (this.fieldKeyCoder.isWithChange()) {
                this.fieldKeyCoder.save(this.recordManager, FIELDKEY_CODER_NAME);
            }
            this.recordManager.commit();
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    private EnteteFiche getEnteteFiche(FicheMeta ficheMeta) throws IOException {
        SubsetItemRecordId recordId = this.subsetItemRecordIdMap.getRecordId(ficheMeta);
        if (recordId == null) {
            return null;
        }
        EnteteFiche enteteFiche = (EnteteFiche)this.recordManager.fetch(recordId.getRecid1(), (Serializer)this.enteteFicheSerializer);
        return enteteFiche;
    }

    private CorpsFiche getCorpsFiche(FicheMeta ficheMeta) throws IOException {
        SubsetItemRecordId recordId = this.subsetItemRecordIdMap.getRecordId(ficheMeta);
        if (recordId == null) {
            return null;
        }
        CorpsFiche corpsFiche = (CorpsFiche)this.recordManager.fetch(recordId.getRecid2(), (Serializer)this.corpsFicheSerializer);
        return corpsFiche;
    }

    private Fiche getFicheComplete(FicheMeta ficheMeta) throws IOException {
        SubsetItemRecordId recordId = this.subsetItemRecordIdMap.getRecordId(ficheMeta);
        if (recordId == null) {
            return null;
        }
        EnteteFiche enteteFiche = (EnteteFiche)this.recordManager.fetch(recordId.getRecid1(), (Serializer)this.enteteFicheSerializer);
        CorpsFiche corpsFiche = (CorpsFiche)this.recordManager.fetch(recordId.getRecid2(), (Serializer)this.corpsFicheSerializer);
        Fiche fiche = enteteFiche.getFiche();
        corpsFiche.setCorpsTo(fiche);
        return fiche;
    }

    private void testIntermediateCommit() {
        ++this.commitCounter;
        if (this.commitCounter > 500) {
            try {
                this.recordManager.commit();
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
            this.commitCounter = 0;
        }
    }

    public EnteteFiche[] getEnteteFicheArray(Corpus corpus) {
        Map<Integer, SubsetItemRecordId> map = this.subsetItemRecordIdMap.getSubsetItemMap(corpus);
        if (map == null || map.isEmpty()) {
            return new EnteteFiche[0];
        }
        TreeMap<Integer, EnteteFiche> sortedMap = new TreeMap<Integer, EnteteFiche>();
        try {
            for (Map.Entry<Integer, SubsetItemRecordId> entry : map.entrySet()) {
                int id = entry.getKey();
                SubsetItemRecordId recordId = entry.getValue();
                EnteteFiche enteteFiche = (EnteteFiche)this.recordManager.fetch(recordId.getRecid1(), (Serializer)this.enteteFicheSerializer);
                sortedMap.put(id, enteteFiche);
            }
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
        EnteteFiche[] array = new EnteteFiche[sortedMap.size()];
        return sortedMap.values().toArray(array);
    }
}

