/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.bdfdata;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.io.File;
import java.io.IOException;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.io.FileUtils;

public class FicheDirectory {
    private final int id;
    private final File dir;

    private FicheDirectory(File dir, int id) {
        this.dir = dir;
        this.id = id;
    }

    public boolean delete() {
        try {
            if (this.dir.exists()) {
                FileUtils.forceDelete(this.dir);
                return true;
            }
            return false;
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public static FicheDirectory getFicheDirectory(StorageDirectory bdfdataDirectory, SubsetKey subsetKey, int id) {
        File docDir = bdfdataDirectory.getDataFile(FicheDirectory.getPath(subsetKey, id));
        FicheDirectory ficheDirectory = new FicheDirectory(docDir, id);
        return ficheDirectory;
    }

    public static String getPath(SubsetKey subsetKey, int id) {
        if (!subsetKey.isCorpusSubset()) {
            throw new IllegalArgumentException("!subsetKey.isCorpusSubset()");
        }
        if (id < 0) {
            throw new IllegalArgumentException("id < 0");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("fichotheque");
        buf.append(File.separatorChar);
        buf.append("corpus");
        buf.append(File.separatorChar);
        buf.append(subsetKey.getSubsetName());
        buf.append(File.separatorChar);
        buf.append("f.");
        buf.append(BdfServerUtils.getMillier(id));
        buf.append(File.separatorChar);
        buf.append(id);
        return buf.toString();
    }
}

