/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.bdfdata;

import fr.exemole.bdfserver.conf.ConfDirs;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.StorageDirectoryUtils;
import java.io.File;
import net.fichotheque.SubsetKey;

public class BdfdataDirectory
implements StorageDirectory {
    private final File bdfdataDir;
    private final File backupDir;
    private final File cacheDir;

    public BdfdataDirectory(File bdfdataDir, File cacheDir, File backupDir) {
        StorageDirectoryUtils.testDirectory(bdfdataDir);
        this.bdfdataDir = bdfdataDir;
        if (cacheDir != null) {
            StorageDirectoryUtils.testDirectory(cacheDir);
            this.cacheDir = cacheDir;
        } else {
            this.cacheDir = null;
        }
        if (backupDir != null) {
            StorageDirectoryUtils.testDirectory(backupDir);
            this.backupDir = backupDir;
        } else {
            this.backupDir = null;
        }
        this.testRelativePath("conf");
        this.testRelativePath("users");
        this.testRelativePath("fichotheque");
    }

    public void testCategoryDirectory(short category) {
        String categoryString = SubsetKey.categoryToString(category);
        File directory = this.getDataFile("fichotheque" + File.separator + categoryString);
        directory.mkdirs();
    }

    private void testRelativePath(String path) {
        File testDirectory = new File(this.bdfdataDir, path);
        StorageDirectoryUtils.testDirectory(testDirectory);
    }

    @Override
    public File getDataDir() {
        return this.bdfdataDir;
    }

    @Override
    public File getBackupDir() {
        return this.backupDir;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public static BdfdataDirectory build(ConfDirs dirs) {
        String subdirName = "bdfdata";
        File bdfdataDir = dirs.getSubPath("var.data", subdirName);
        File backupDir = dirs.getSubPath("var.backup", subdirName);
        File cacheDir = dirs.getDir("var.cache");
        return new BdfdataDirectory(bdfdataDir, cacheDir, backupDir);
    }
}

