/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.fichotheque;

import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.MultiEditor;
import fr.exemole.bdfserver.multi.api.MultiMetadata;
import fr.exemole.bdfserver.multi.api.MultiMetadataEditor;
import fr.exemole.bdfserver.multi.api.namespaces.FichothequeSpace;
import fr.exemole.bdfserver.multi.commands.AbstractMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.EditOrigin;
import net.fichotheque.utils.EditOriginUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class FichothequeActionCommand
extends AbstractMultiCommand {
    public static final String COMMAND_NAME = "FichothequeAction";
    public static final String NAME_PARAMNAME = "name";
    public static final String ACTION_PARAMNAME = "action";

    public FichothequeActionCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        CommandMessage commandMessage;
        String action;
        String name = this.getFichothequeName(NAME_PARAMNAME);
        switch (action = this.getMandatory(ACTION_PARAMNAME)) {
            case "start": {
                commandMessage = this.start(name);
                break;
            }
            case "stop": {
                commandMessage = this.stop(name);
                break;
            }
            default: {
                throw BdfErrors.unknownParameterValue(ACTION_PARAMNAME, action);
            }
        }
        return commandMessage;
    }

    private CommandMessage start(String name) throws ErrorMessageException {
        Attribute currentAttribute = this.multi.getMultiMetadata().getAttributes().getAttribute(FichothequeSpace.INACTIVE_KEY);
        if (currentAttribute == null) {
            return this.done("_ info.multi.activefichotheque", name);
        }
        AttributeBuilder attributeBuilder = new AttributeBuilder(FichothequeSpace.INACTIVE_KEY);
        boolean done = false;
        for (String value : currentAttribute) {
            if (value.equals(name)) {
                done = true;
                continue;
            }
            attributeBuilder.addValue(value);
        }
        if (!done) {
            return this.done("_ info.multi.activefichotheque", name);
        }
        this.updateInactiveAttribute("start", attributeBuilder.toAttribute());
        return this.done("_ done.multi.action_start", name);
    }

    private CommandMessage stop(String name) throws ErrorMessageException {
        Attribute currentAttribute = this.multi.getMultiMetadata().getAttributes().getAttribute(FichothequeSpace.INACTIVE_KEY);
        AttributeBuilder attributeBuilder = new AttributeBuilder(FichothequeSpace.INACTIVE_KEY);
        boolean here = false;
        if (currentAttribute != null) {
            for (String value : currentAttribute) {
                if (value.equals(name)) {
                    here = true;
                    break;
                }
                attributeBuilder.addValue(value);
            }
        }
        if (here) {
            return this.done("_ info.multi.inactivefichotheque", name);
        }
        attributeBuilder.addValue(name);
        this.updateInactiveAttribute("stop", attributeBuilder.toAttribute());
        return this.done("_ done.multi.action_stop", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInactiveAttribute(String action, Attribute attribute) {
        MultiMetadata metadata;
        EditOrigin editOrigin = EditOriginUtils.newEditOrigin("multi-admin/action-" + action);
        MultiMetadata multiMetadata = metadata = this.multi.getMultiMetadata();
        synchronized (multiMetadata) {
            MultiEditor multiEditor = this.multi.getMultiEditor(editOrigin);
            MultiMetadataEditor multiMetadataEditor = multiEditor.getMultiMetadataEditor();
            if (attribute == null) {
                multiMetadataEditor.removeAttribute(FichothequeSpace.INACTIVE_KEY);
            } else {
                multiMetadataEditor.putAttribute(attribute);
            }
            multiEditor.saveChanges();
        }
    }
}

