/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.MetadataEditor;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.LabelChange;

public class CentralSphereMetadataCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "CentralSphereMetadata";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";

    public CentralSphereMetadataCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        boolean done;
        this.initCentralSphere();
        this.initCentralEditors();
        LabelChange titleLabelChange = BdfCommandUtils.getLabelChange(this.requestMap, TITLE_PARAMPREFIX, true);
        HashMap<String, LabelChange> phraseChangeMap = new HashMap<String, LabelChange>();
        BdfCommandUtils.populatePhraseLabelChange(this.requestMap, phraseChangeMap);
        String attributes = this.requestMap.getParameter(ATTRIBUTES_PARAMNAME);
        AttributeChange attributeChange = null;
        if (attributes != null) {
            attributeChange = AttributeParser.parse(attributes);
        }
        CentralSphere centralSphere = this.getCentralSphere();
        synchronized (centralSphere) {
            done = this.update(this.centralSphereEditor.getMetadataEditor(), titleLabelChange, phraseChangeMap, attributeChange);
            if (done) {
                this.saveChanges();
            }
        }
        if (done) {
            return this.done("_ done.multi.metadata");
        }
        return null;
    }

    private boolean update(MetadataEditor metadataEditor, LabelChange titleLabelChange, Map<String, LabelChange> phraseChangeMap, AttributeChange attributeChange) {
        boolean done = false;
        if (metadataEditor.changeLabels(null, titleLabelChange)) {
            done = true;
        }
        for (Map.Entry<String, LabelChange> entry : phraseChangeMap.entrySet()) {
            if (!metadataEditor.changeLabels(entry.getKey(), entry.getValue())) continue;
            done = true;
        }
        if (attributeChange != null && metadataEditor.changeAttributes(attributeChange)) {
            done = true;
        }
        return done;
    }
}

