/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.session;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.json.BdfUserJson;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.io.IOException;
import net.mapeadores.util.json.CommonJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;

public class PingJsonProducer
implements JsonProducer {
    private final boolean authentified;
    private final MessageLocalisation messageLocalisation;
    private final CommandMessage commandMessage;
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;

    public PingJsonProducer(boolean authentified, MessageLocalisation messageLocalisation, CommandMessage commandMessage, BdfServer bdfServer, BdfUser bdfUser) {
        this.authentified = authentified;
        this.messageLocalisation = messageLocalisation;
        this.commandMessage = commandMessage;
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
    }

    @Override
    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("authentified").value(this.authentified);
        if (this.bdfUser != null) {
            BdfUserJson.properties(jw, this.bdfUser);
            jw.key("admin").value(BdfUserUtils.isAdmin(this.bdfServer, this.bdfUser));
            jw.key("roleArray");
            jw.array();
            for (Role role : this.bdfServer.getPermissionManager().getRoleList(this.bdfUser.getRedacteur())) {
                jw.object();
                jw.key("name").value(role.getName());
                jw.key("attrMap");
                CommonJson.object(jw, role.getAttributes());
                CommonJson.title(jw, role.getTitleLabels(), this.bdfUser.getWorkingLang());
                jw.endObject();
            }
            jw.endArray();
        }
        if (this.commandMessage != null) {
            jw.key("commandMessage");
            CommonJson.object(jw, this.commandMessage, this.messageLocalisation);
        }
        jw.endObject();
    }

    public static PingJsonProducer unauthentified(MessageLocalisation messageLocalisation, CommandMessage commandMessage) {
        return new PingJsonProducer(false, messageLocalisation, commandMessage, null, null);
    }

    public static PingJsonProducer authentified(BdfServer bdfServer, BdfUser bdfUser) {
        if (bdfServer == null) {
            throw new IllegalArgumentException("bdfServer is null");
        }
        if (bdfUser == null) {
            throw new IllegalArgumentException("bdfUser is null");
        }
        return new PingJsonProducer(true, null, null, bdfServer, bdfUser);
    }

    public static PingJsonProducer authentified(BdfServer bdfServer, BdfUser bdfUser, MessageLocalisation messageLocalisation, CommandMessage commandMessage) {
        if (bdfServer == null) {
            throw new IllegalArgumentException("bdfServer is null");
        }
        if (bdfUser == null) {
            throw new IllegalArgumentException("bdfUser is null");
        }
        return new PingJsonProducer(true, messageLocalisation, commandMessage, bdfServer, bdfUser);
    }
}

