/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.jsonproducers.configuration.ExternalScriptArrayJsonProperty;
import fr.exemole.bdfserver.jsonproducers.configuration.LangConfigurationJsonProperty;
import fr.exemole.bdfserver.jsonproducers.configuration.PathConfigurationJsonProperty;
import fr.exemole.bdfserver.jsonproducers.configuration.SubsetTreesJsonProperty;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import java.util.LinkedHashSet;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public final class ConfigurationJsonProducerFactory {
    private ConfigurationJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String json = parameters.getOutput();
        ResultJsonProducer jsonProducer = new ResultJsonProducer(parameters);
        JsonProperty jsonProperty = ConfigurationJsonProducerFactory.getJsonProperty(requestHandler, json);
        if (jsonProperty == null) {
            return null;
        }
        jsonProducer.add(jsonProperty);
        return jsonProducer;
    }

    public static JsonProperty getJsonProperty(OutputRequestHandler requestHandler, String name) throws ErrorMessageException {
        BdfServer bdfServer = requestHandler.getBdfServer();
        RequestMap requestMap = requestHandler.getRequestMap();
        switch (name) {
            case "subsettrees": {
                boolean withDetails = requestMap.isTrue("withdetails");
                return new SubsetTreesJsonProperty(bdfServer, requestHandler.getPermissionSummary(), requestHandler.getWorkingLang(), ConfigurationJsonProducerFactory.getCategoryArray(requestHandler), withDetails);
            }
            case "langconfiguration": {
                return new LangConfigurationJsonProperty(bdfServer);
            }
            case "pathconfiguration": {
                return new PathConfigurationJsonProperty(PathConfigurationBuilder.build(bdfServer));
            }
            case "externalscript-array": {
                return new ExternalScriptArrayJsonProperty(bdfServer);
            }
        }
        return null;
    }

    private static short[] getCategoryArray(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String[] categoriesArray = requestHandler.getTokens("categories");
        LinkedHashSet<Short> categorySet = new LinkedHashSet<Short>();
        int categoriesLength = categoriesArray.length;
        for (int j = 0; j < categoriesLength; ++j) {
            String[] tokensArray = StringUtils.getTechnicalTokens(categoriesArray[j], true);
            int length = tokensArray.length;
            for (int i = 0; i < length; ++i) {
                try {
                    categorySet.add(SubsetKey.categoryToShort(tokensArray[i]));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw BdfErrors.unknownParameterValue("categories", tokensArray[i]);
                }
            }
        }
        short[] result = new short[categorySet.size()];
        int p = 0;
        for (Short sh : categorySet) {
            result[p] = sh;
            ++p;
        }
        return result;
    }
}

