/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.sphere;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.RedacteurAdminFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.RedacteurAvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.RedacteurCreationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.RedacteurPreferencesHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.RedacteurStatsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.RedacteurUserFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereCreationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereMetadataFormHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.logging.ErrorMessageException;

public final class SphereHtmlProducerFactory {
    private static final int SPHERE_ADMIN = 1;
    private static final int REDACTEUR_ADMIN = 2;

    private SphereHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String page = parameters.getOutput();
        PermissionChecker permissionChecker = requestHandler.getPermissionChecker();
        switch (SphereHtmlProducerFactory.getPageType(page)) {
            case 1: {
                Sphere sphere = requestHandler.getSphere();
                permissionChecker.checkSubsetAdmin(sphere);
                switch (page) {
                    case "sphere-advancedcommands": {
                        return new SphereAdvancedCommandsHtmlProducer(parameters, sphere);
                    }
                    case "sphere-metadataform": {
                        return new SphereMetadataFormHtmlProducer(parameters, sphere);
                    }
                    case "redacteur-creationform": {
                        return new RedacteurCreationFormHtmlProducer(parameters, sphere);
                    }
                }
                return null;
            }
            case 2: {
                Redacteur redacteur = requestHandler.getRedacteur();
                permissionChecker.checkSubsetAdmin(redacteur.getSphere());
                switch (page) {
                    case "redacteur-advancedcommands": {
                        return new RedacteurAvancedCommandsHtmlProducer(parameters, redacteur);
                    }
                    case "redacteur-adminform": {
                        return new RedacteurAdminFormHtmlProducer(parameters, redacteur);
                    }
                    case "redacteur-preferences": {
                        return new RedacteurPreferencesHtmlProducer(parameters, redacteur);
                    }
                    case "redacteur-stats": {
                        return new RedacteurStatsHtmlProducer(parameters, redacteur);
                    }
                }
                return null;
            }
        }
        switch (page) {
            case "redacteur-userform": {
                return new RedacteurUserFormHtmlProducer(parameters);
            }
            case "sphere": {
                Sphere sphere = requestHandler.getSphere();
                return new SphereHtmlProducer(parameters, sphere);
            }
            case "sphere-creationform": {
                permissionChecker.checkFichothequeAdmin();
                return new SphereCreationFormHtmlProducer(parameters);
            }
        }
        return null;
    }

    private static int getPageType(String page) {
        switch (page) {
            case "sphere-metadataform": 
            case "sphere-advancedcommands": 
            case "redacteur-creationform": {
                return 1;
            }
            case "redacteur-adminform": 
            case "redacteur-preferences": 
            case "redacteur-stats": 
            case "redacteur-advancedcommands": {
                return 2;
            }
        }
        return 0;
    }
}

