/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.misc;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.L10nManager;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.SubsetIcon;
import java.util.Set;
import java.util.function.Consumer;
import net.mapeadores.util.html.HtmlPrinter;

public class IsoHtmlProducer
extends BdfServerHtmlProducer {
    private Set<String> keySet;
    private final String titleMessageKey;
    private final Consumer<HtmlPrinter> icon;

    public IsoHtmlProducer(BdfParameters bdfParameters, String pageName) {
        super(bdfParameters);
        L10nManager l10nManager = this.bdfServer.getL10nManager();
        if (pageName.equals("iso-languages")) {
            this.keySet = l10nManager.getCodeCatalog().getLangCodeSet();
            this.titleMessageKey = "_ title.misc.lang_list";
            this.icon = SubsetIcon.COUNTRY;
        } else if (pageName.equals("iso-countries")) {
            this.keySet = l10nManager.getCodeCatalog().getCountryCodeSet();
            this.titleMessageKey = "_ title.misc.country_list";
            this.icon = SubsetIcon.LANG;
        } else {
            this.titleMessageKey = "";
            this.icon = null;
        }
        this.addThemeCss("misc.css");
    }

    @Override
    public void printHtml() {
        this.startLoc(this.titleMessageKey);
        this.__(PageUnit.start(this.titleMessageKey).sectionCss("unit-Unit misc-iso-Unit").icon(this.icon)).TABLE("misc-iso-Table");
        for (String key : this.keySet) {
            this.TR().TD().__escape(key)._TD().TD().__localize(key)._TD()._TR();
        }
        this._TABLE().__(PageUnit.END);
        this.end();
    }
}

