/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.importation;

import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.importation.CorpusImportHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.importation.ImportationConfirmHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.importation.LabelImportHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.importation.ThesaurusImportHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import net.fichotheque.importation.ParseResult;
import net.mapeadores.util.logging.ErrorMessageException;

public final class ImportationHtmlProducerFactory {
    private ImportationHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        PermissionChecker.init(parameters).checkFichothequeAdmin();
        String page = parameters.getOutput();
        BdfCommandResult bdfCommandResult = parameters.getBdfCommandResult();
        switch (page) {
            case "labelimport": {
                return new LabelImportHtmlProducer(parameters);
            }
            case "thesaurusimport": {
                return new ThesaurusImportHtmlProducer(parameters);
            }
            case "corpusimport": {
                return new CorpusImportHtmlProducer(parameters);
            }
            case "importation-confirm": {
                if (bdfCommandResult != null) {
                    ParseResult parseResult = (ParseResult)bdfCommandResult.getResultObject("obj.parseresult");
                    return new ImportationConfirmHtmlProducer(parameters, parseResult);
                }
                return null;
            }
        }
        return null;
    }
}

