/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormEntryProvider;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.namespaces.CommandSpace;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.CreationConfirmHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FicheFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FicheIndexationHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FicheResultHandler;
import fr.exemole.bdfserver.htmlproducers.edition.FicheResultHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FilesUploadFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FilesUploadResultHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.SatelliteFicheCreationHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.SectionPreviewHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.ZoomEditHtmlProducer;
import fr.exemole.bdfserver.tools.ficheform.FicheFormParametersBuilder;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.FormEntryProviderFactory;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadResult;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.tools.duplication.DuplicationFilter;
import net.fichotheque.tools.duplication.DuplicationFilterParser;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.PointeurUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.logging.ErrorMessageException;

public final class EditionHtmlProducerFactory {
    private static final Predicate<FieldKey> ALL_FIELDKEY_PREDICATE = fieldKey -> true;

    private EditionHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page;
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        PermissionChecker permissionChecker = requestHandler.getPermissionChecker();
        switch (page = parameters.getOutput()) {
            case "zoomedit": {
                String callKey = requestHandler.getCallKey();
                String corpusName = requestHandler.getMandatoryParameter("corpus");
                return new ZoomEditHtmlProducer(parameters, callKey, corpusName);
            }
            case "fiche-result": {
                FicheResultHandler ficheResultHandler = FicheResultHandler.build(requestHandler.getFicheMeta(), requestHandler);
                return new FicheResultHtmlProducer(parameters, ficheResultHandler);
            }
            case "fiche-indexation": {
                FicheMeta ficheMeta = requestHandler.getFicheMeta();
                permissionChecker.checkSubsetAdmin(ficheMeta.getCorpus());
                FichePointeur fichePointeur = PointeurFactory.newFichePointeur(ficheMeta.getCorpus()).setCurrentFicheMeta(ficheMeta);
                FormEntryProvider formEntryProvider = FormEntryProviderFactory.newInstance(FicheFormParametersBuilder.build(parameters).toFicheFormParameters());
                return new FicheIndexationHtmlProducer(parameters, fichePointeur, formEntryProvider);
            }
            case "fiche-creation": {
                Corpus corpus = requestHandler.getCorpus();
                permissionChecker.checkFicheCreate(corpus);
                String prefill = requestHandler.getTrimedParameter("prefill");
                boolean isDuplicate = prefill.equals("duplicate");
                if (corpus.getMasterSubset() != null) {
                    if (isDuplicate) {
                        throw BdfErrors.error("_ error.unsupported.satellitecorpus", corpus.getSubsetName());
                    }
                    return new SatelliteFicheCreationHtmlProducer(parameters, corpus);
                }
                FichePointeur fichePointeur = PointeurFactory.newFichePointeur(corpus, true);
                if (isDuplicate) {
                    FicheMeta ficheMeta = requestHandler.getFicheMeta();
                    fichePointeur.setCurrentSubsetItem(ficheMeta);
                    boolean isWritable = requestHandler.getPermissionSummary().canWrite(ficheMeta);
                    fichePointeur = EditionHtmlProducerFactory.filterDuplicateFichePointeur(corpus, fichePointeur, !isWritable);
                }
                FicheFormParameters ficheFormParameters = FicheFormUtils.initFicheFormParametersBuilder(parameters).setDuplicate(isDuplicate).toFicheFormParameters();
                FormEntryProvider formEntryProvider = FormEntryProviderFactory.newInstance(ficheFormParameters);
                FicheFormHtmlProducer ficheFormHtmlProducer = FicheFormHtmlProducer.newCreationInstance(parameters, fichePointeur, formEntryProvider);
                EditionHtmlProducerFactory.checkOptions(ficheFormHtmlProducer, requestHandler);
                return ficheFormHtmlProducer;
            }
            case "fiche-change": {
                Corpus corpus = requestHandler.getCorpus();
                FichePointeur fichePointeur = PointeurFactory.newFichePointeur(corpus, true);
                int id = -1;
                FicheMeta ficheMeta = (FicheMeta)parameters.getResultObject("obj.fichemeta");
                if (ficheMeta == null) {
                    id = requestHandler.getMandatoryId();
                    ficheMeta = corpus.getFicheMetaById(id);
                }
                if (ficheMeta != null) {
                    permissionChecker.checkWrite(ficheMeta);
                    fichePointeur.setCurrentSubsetItem(ficheMeta);
                    FicheFormParameters ficheFormParameters = FicheFormUtils.initFicheFormParametersBuilder(parameters).toFicheFormParameters();
                    FormEntryProvider formEntryProvider = FormEntryProviderFactory.newInstance(ficheFormParameters);
                    FicheFormHtmlProducer ficheFormHtmlProducer = FicheFormHtmlProducer.newChangeInstance(parameters, fichePointeur, formEntryProvider);
                    EditionHtmlProducerFactory.checkOptions(ficheFormHtmlProducer, requestHandler);
                    return ficheFormHtmlProducer;
                }
                permissionChecker.checkFicheCreate(corpus);
                SubsetItem masterSubsetItem = BdfInstructionUtils.checkMasterSubsetItem(corpus, id, parameters.getBdfUser());
                boolean force = requestHandler.isTrue("force");
                if (!force) {
                    return new CreationConfirmHtmlProducer(parameters, corpus, id, masterSubsetItem);
                }
                FormEntryProvider formEntryProvider = FormEntryProviderFactory.newInstance(FicheFormUtils.initFicheFormParametersBuilder(parameters).setMasterSubsetItem(masterSubsetItem).toFicheFormParameters());
                FicheFormHtmlProducer ficheFormHtmlProducer = masterSubsetItem != null ? FicheFormHtmlProducer.newCreationInstance((BdfParameters)parameters, fichePointeur, masterSubsetItem, formEntryProvider) : FicheFormHtmlProducer.newCreationInstance((BdfParameters)parameters, fichePointeur, id, formEntryProvider);
                EditionHtmlProducerFactory.checkOptions(ficheFormHtmlProducer, requestHandler);
                return ficheFormHtmlProducer;
            }
            case "sectionpreview": {
                Corpus corpus = requestHandler.getCorpus();
                return new SectionPreviewHtmlProducer(parameters, corpus);
            }
            case "filesupload-form": {
                return new FilesUploadFormHtmlProducer(parameters, requestHandler.getMode(), requestHandler.getCallKey());
            }
            case "filesupload-result": {
                FilesUploadResult filesUploadResult = (FilesUploadResult)parameters.getResultObject("obj.filesuploadresult");
                if (filesUploadResult == null) {
                    throw BdfErrors.missingCommandResultPage("filesupload-result");
                }
                return new FilesUploadResultHtmlProducer(parameters, filesUploadResult, requestHandler.getCallKey());
            }
        }
        return null;
    }

    private static void checkOptions(FicheFormHtmlProducer ficheFormHtmlProducer, OutputRequestHandler requestHandler) throws ErrorMessageException {
        String resultPageOptions;
        String resultPage = requestHandler.getTrimedParameter("page-result");
        if (!resultPage.isEmpty()) {
            ficheFormHtmlProducer.setFicheResultPage(resultPage);
        }
        if (!(resultPageOptions = requestHandler.getTrimedParameter("page-result-options")).isEmpty()) {
            ficheFormHtmlProducer.setResultPageOptions(resultPageOptions);
        }
        ficheFormHtmlProducer.setGotoAtStart(requestHandler.getTrimedParameter("goto"));
    }

    private static FichePointeur filterDuplicateFichePointeur(Corpus corpus, FichePointeur originalFichePointeur, boolean excludeJunctionTest) {
        Attribute excludeAttribute = corpus.getCorpusMetadata().getAttributes().getAttribute(CommandSpace.DUPLICATION_EXCLUDE_KEY);
        if (excludeAttribute == null && !excludeJunctionTest) {
            return originalFichePointeur;
        }
        SubsetEligibility subsetEligibility = EligibilityUtils.ALL_SUBSET_ELIGIBILITY;
        Predicate<FieldKey> fieldKeyPredicate = ALL_FIELDKEY_PREDICATE;
        if (excludeAttribute != null) {
            DuplicationFilter duplicationFilter = DuplicationFilterParser.parseExclude(excludeAttribute);
            subsetEligibility = duplicationFilter.getSubsetEligibility();
            fieldKeyPredicate = duplicationFilter.getFieldPredicate();
        }
        if (excludeJunctionTest) {
            subsetEligibility = new FilterSubsetEligibility(subsetEligibility);
        }
        return PointeurUtils.filter(originalFichePointeur, subsetEligibility, fieldKeyPredicate);
    }

    private static class FilterSubsetEligibility
    implements SubsetEligibility {
        private final SubsetEligibility originalSubsetEligibility;

        private FilterSubsetEligibility(SubsetEligibility originalSubsetEligibility) {
            this.originalSubsetEligibility = originalSubsetEligibility;
        }

        @Override
        public boolean accept(SubsetKey subsetKey) {
            switch (subsetKey.getCategory()) {
                case 4: 
                case 5: {
                    return false;
                }
            }
            return this.originalSubsetEligibility.accept(subsetKey);
        }

        @Override
        public Predicate<SubsetItem> getPredicate(Subset subset) {
            switch (subset.getSubsetKey().getCategory()) {
                case 4: 
                case 5: {
                    return EligibilityUtils.NONE_SUBSETITEM_PREDICATE;
                }
            }
            return this.originalSubsetEligibility.getPredicate(subset);
        }
    }
}

