/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.consumers.AttributesText;
import fr.exemole.bdfserver.html.consumers.Common;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.JunctionSelection;
import fr.exemole.bdfserver.html.consumers.MetadataPhrases;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.consumers.attributes.InputPattern;
import fr.exemole.bdfserver.html.consumers.commandbox.Flag;
import fr.exemole.bdfserver.htmlproducers.CommandBoxUtils;
import fr.exemole.bdfserver.tools.ui.MetadataPhraseDefCatalog;
import java.util.List;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.metadata.AddendaMetadata;
import net.fichotheque.junction.JunctionsBySubset;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;

public final class AddendaCommandBoxUtils {
    private AddendaCommandBoxUtils() {
    }

    public static boolean printAddendaCreationBox(HtmlPrinter hp, CommandBox commandBox) {
        commandBox = commandBox.derive("AddendaCreation", "_ ADD-01").actionCssClass("action-New").__(Flag.UPDATE_COLLECTIONS).submitLocKey("_ submit.addenda.addendacreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.addenda.newaddendaname", hp.name("newaddenda").size("30").populate(InputPattern.TECHNICAL_STRICT).required(true))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printAddendaPhrasesBox(HtmlPrinter hp, CommandBox commandBox, Addenda addenda, BdfServer bdfServer) {
        AddendaMetadata addendaMetadata = addenda.getAddendaMetadata();
        MetadataPhrases metadataPhrases = MetadataPhrases.init(addendaMetadata, bdfServer.getLangConfiguration().getWorkingLangs(), "_ label.addenda.title").addDef(MetadataPhraseDefCatalog.getMetadataPhraseDef("naming")).populateFromAttributes(addenda).addExtensionPhraseDefList(bdfServer);
        commandBox = commandBox.derive("AddendaPhrases", "_ ADD-02").__(CommandBoxUtils.insert(addenda)).actionCssClass("action-Labels").submitLocKey("_ submit.addenda.addendaphrases");
        hp.__start(commandBox).__(metadataPhrases).__end(commandBox);
        return true;
    }

    public static boolean printAddendaRemoveBox(HtmlPrinter hp, CommandBox commandBox, Addenda addenda) {
        commandBox = commandBox.derive("AddendaRemove", "_ ADD-04").__(CommandBoxUtils.insert(addenda)).__(Flag.UPDATE_COLLECTIONS).actionCssClass("action-Delete").submitLocKey("_ submit.addenda.addendaremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printAddendaAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, Addenda addenda) {
        commandBox = commandBox.derive("AddendaAttributeChange", "_ ADD-03").__(CommandBoxUtils.insert(addenda)).actionCssClass("action-Attributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(addenda.getAddendaMetadata().getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printDocumentAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, Document document) {
        commandBox = commandBox.derive("DocumentAttributeChange", "_ ADD-07").__(CommandBoxUtils.insert(document)).actionCssClass("action-Attributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(document.getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printDocumentNameChangeBox(HtmlPrinter hp, CommandBox commandBox, Document document, Lang workingLang) {
        commandBox = commandBox.derive("DocumentNameChange", "_ ADD-05").__(CommandBoxUtils.insert(document)).submitLocKey("_ submit.addenda.documentnamechange");
        hp.__start(commandBox);
        String namingConvention = FichothequeUtils.getPhraseLabel(document.getAddenda().getMetadata().getPhrases(), "naming", workingLang);
        if (namingConvention != null) {
            hp.P("global-SubTitle").__escape(namingConvention)._P();
        }
        hp.__(Grid.START).__(Grid.textInputRow("_ label.addenda.documentname", hp.name("documentname").value(document.getBasename()).size("30").populate(InputPattern.DOCUMENTNAME).required(true))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printDocumentRemoveBox(HtmlPrinter hp, CommandBox commandBox, Document document) {
        commandBox = commandBox.derive("DocumentRemove", "_ ADD-06").__(CommandBoxUtils.insert(document)).actionCssClass("action-Delete").submitLocKey("_ submit.addenda.documentremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printJunctionRemoveBox(HtmlPrinter hp, CommandBox commandBox, Document document, List<JunctionsBySubset> junctionsBySubsetList, PermissionSummary permissionSummary, BdfUser bdfUser) {
        commandBox = commandBox.derive("JunctionRemove", "_ ADD-08").__(CommandBoxUtils.insert(document)).actionCssClass("action-Delete").submitLocKey("_ submit.global.junctionremove");
        hp.__start(commandBox).__(new JunctionSelection("remove", junctionsBySubsetList, bdfUser.getWorkingLang(), bdfUser.getFormatLocale())).__(BdfHtmlUtils.printJunctionRemoveWarning(hp, document.getSubsetKey(), permissionSummary)).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printJunctionAddBox(HtmlPrinter hp, CommandBox commandBox, Document document) {
        commandBox = commandBox.derive("JunctionAdd", "_ ADD-09").__(CommandBoxUtils.insert(document)).actionCssClass("action-New").submitLocKey("_ submit.global.junctionadd");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow("_ label.global.junctionadd", hp.name("add").cols(60).rows(3).populate(Appelant.fiche()))).__(Grid.END).__end(commandBox);
        return true;
    }
}

