/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.forms;

import fr.exemole.bdfserver.api.ficheform.include.ThesaurusEntry;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;

public class InputItem {
    public static final int DASH_IDALPHASTYLE = 1;
    public static final int BRACKETS_IDALPHASTYLE = 2;
    public static final int IGNORE_IDALPHASTYLE = 3;
    private final String value;
    private final String labelText;
    private final boolean selected;
    private final int depth;
    private final boolean shouldNotUse;
    private final boolean group;
    private final List<InputItem> childList = new ArrayList<InputItem>();

    public InputItem(String value, String labelText, boolean selected, int depth, boolean shouldNotUse, boolean group) {
        this.value = value;
        this.labelText = labelText;
        this.selected = selected;
        this.depth = depth;
        this.shouldNotUse = shouldNotUse;
        this.group = group;
    }

    public String getValue() {
        return this.value;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isGroup() {
        return this.group && this.shouldNotUse && !this.selected;
    }

    public boolean isShouldNotUse() {
        return this.shouldNotUse;
    }

    public void addChild(InputItem inputItem) {
        this.childList.add(inputItem);
    }

    private boolean testIsShouldNotUse() {
        if (!this.shouldNotUse) {
            return false;
        }
        if (this.selected) {
            return false;
        }
        if (this.childList.isEmpty()) {
            return true;
        }
        for (InputItem inputItem : this.childList) {
            if (inputItem.testIsShouldNotUse()) continue;
            return false;
        }
        return true;
    }

    public static void populateInputItems(ThesaurusEntry.Choice formEntry, Lang lang, List<InputItem> inputItemList) {
        int style = InputItem.getStyleValue(formEntry.getIdalphaStyle());
        Thesaurus thesaurus = formEntry.getThesaurus();
        for (Motcle firstLevelMotcle : thesaurus.getFirstLevelList()) {
            InputItem.populateInputItem(firstLevelMotcle, formEntry, lang, inputItemList, style);
        }
    }

    private static void populateInputItem(Motcle motcle, ThesaurusEntry.Choice formEntry, Lang lang, List<InputItem> inputItemList, int style) {
        InputItem inputItem = InputItem.toInputItem(motcle, formEntry, lang, 1, style);
        if (inputItem != null) {
            inputItemList.add(inputItem);
            for (Motcle child : motcle.getChildList()) {
                InputItem.populateInputItem(child, formEntry, lang, inputItem, 2, style);
            }
        } else {
            for (Motcle child : motcle.getChildList()) {
                InputItem.populateInputItem(child, formEntry, lang, inputItemList, style);
            }
        }
    }

    private static void populateInputItem(Motcle motcle, ThesaurusEntry.Choice formEntry, Lang lang, InputItem parent, int depth, int style) {
        InputItem inputItem = InputItem.toInputItem(motcle, formEntry, lang, depth, style);
        if (inputItem != null) {
            parent.addChild(inputItem);
            for (Motcle child : motcle.getChildList()) {
                InputItem.populateInputItem(child, formEntry, lang, inputItem, depth + 1, style);
            }
        } else {
            for (Motcle child : motcle.getChildList()) {
                InputItem.populateInputItem(child, formEntry, lang, parent, depth, style);
            }
        }
    }

    private static InputItem toInputItem(Motcle motcle, ThesaurusEntry.Choice formEntry, Lang lang, int depth, int style) {
        boolean selected = formEntry.contains(motcle);
        if (!selected && !formEntry.getFilterPredicate().test(motcle)) {
            return null;
        }
        String idalpha = motcle.getIdalpha();
        String currentValue = idalpha != null ? idalpha : String.valueOf(motcle.getId());
        String labelText = InputItem.getText(motcle, lang, style);
        labelText = InputItem.checkLength(labelText, 50);
        boolean shouldNotUse = motcle.shouldNotJunction(formEntry.getDestinationSubsetKey());
        boolean group = motcle.getStatus().equals("group");
        InputItem inputItem = new InputItem(currentValue, labelText, selected, depth, shouldNotUse, group);
        return inputItem;
    }

    public static boolean printInputList(HtmlPrinter hp, List<InputItem> inputItemList, HtmlAttributes inputAttr) {
        for (InputItem inputItem : inputItemList) {
            if (!inputItem.isShouldNotUse() || inputItem.isSelected()) {
                String value = inputItem.getValue();
                String genId = hp.generateId();
                hp.DIV("ficheform-Choice").INPUT(inputAttr.id(genId).value(value).checked(inputItem.isSelected())).LABEL_for(genId).__escape(inputItem.getLabelText())._LABEL()._DIV();
            }
            if (inputItem.childList.isEmpty()) continue;
            InputItem.printInputList(hp, inputItem.childList, inputAttr);
        }
        return true;
    }

    public static boolean printOptions(HtmlPrinter hp, List<InputItem> inputItemList) {
        for (InputItem inputItem : inputItemList) {
            if (inputItem.testIsShouldNotUse()) continue;
            int depth = inputItem.getDepth();
            if (inputItem.isGroup()) {
                StringBuilder buf = new StringBuilder();
                for (int i = 2; i <= depth; ++i) {
                    buf.append("\u00a0 \u00a0 ");
                }
                buf.append(inputItem.getLabelText());
                hp.OPTGROUP(HA.label(buf.toString()))._OPTGROUP();
            } else {
                if (inputItem.isShouldNotUse() && !inputItem.isSelected()) {
                    hp.OPTION(HA.value(inputItem.getValue()).selected(inputItem.isSelected()).disabled(true));
                } else {
                    hp.OPTION(inputItem.getValue(), inputItem.isSelected());
                }
                for (int i = 2; i <= depth; ++i) {
                    hp.__doublespace().__doublespace();
                }
                hp.__escape(inputItem.getLabelText())._OPTION();
            }
            if (inputItem.childList.isEmpty()) continue;
            InputItem.printOptions(hp, inputItem.childList);
        }
        return true;
    }

    private static String checkLength(String text, int maxStringLength) {
        if (maxStringLength < 1 || text.length() <= maxStringLength) {
            return text;
        }
        return text.substring(0, maxStringLength) + "\u2026";
    }

    public static int getStyleValue(Attribute attribute) {
        int style = 1;
        if (attribute != null) {
            if (attribute.contains("brackets")) {
                style = 2;
            } else if (attribute.contains("ignore")) {
                style = 3;
            }
        }
        return style;
    }

    public static String getText(Motcle motcle, Lang lang, int idalphaStyle) {
        if (motcle.isBabelienType()) {
            return motcle.getBabelienLabel().getLabelString();
        }
        StringBuilder buf = new StringBuilder();
        String idalpha = motcle.getSignificantIdalpha();
        Label label = motcle.getLabels().getLangPartCheckedLabel(lang);
        if (idalpha != null && idalphaStyle != 3) {
            if (idalphaStyle == 2) {
                buf.append('[');
                buf.append(idalpha);
                buf.append(']');
                if (label != null) {
                    buf.append(' ');
                    buf.append(label.getLabelString());
                }
            } else {
                buf.append(idalpha);
                if (label != null) {
                    buf.append(" \u2013 ");
                    buf.append(label.getLabelString());
                }
            }
        } else if (label != null) {
            buf.append(label.getLabelString());
        } else {
            buf.append(String.valueOf(motcle.getId()));
        }
        return buf.toString();
    }
}

