/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers;

import fr.exemole.bdfserver.html.consumers.Grid;
import java.util.function.Consumer;
import net.fichotheque.syntax.FormSyntax;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;

public class LangRows
implements Consumer<HtmlPrinter> {
    private final String namePrefix;
    private final Labels labels;
    private final Lang[] langArray;
    private final Langs langs;
    private final String[] textArray;
    private int cols = 50;
    private int rows = 1;
    private String codemirrorMode = null;
    private boolean displayOnly = false;
    private boolean preformatted = false;

    public LangRows(String namePrefix, Lang[] langArray, String[] textArray) {
        this.namePrefix = namePrefix;
        this.labels = null;
        this.langArray = langArray;
        this.langs = null;
        this.textArray = textArray;
    }

    public LangRows(String namePrefix, @Nullable Labels labels, Langs langs) {
        this.namePrefix = namePrefix;
        this.labels = labels;
        this.langArray = null;
        this.langs = langs;
        this.textArray = null;
    }

    public LangRows cols(int cols) {
        this.cols = cols;
        return this;
    }

    public LangRows rows(int rows) {
        this.rows = rows;
        return this;
    }

    public LangRows displayOnly(boolean displayOnly) {
        this.displayOnly = displayOnly;
        return this;
    }

    public LangRows preformatted(boolean preformatted) {
        this.preformatted = preformatted;
        return this;
    }

    public LangRows codemirrorMode(String codemirrorMode) {
        this.codemirrorMode = codemirrorMode;
        return this;
    }

    @Override
    public void accept(HtmlPrinter hp) {
        block6: {
            block5: {
                if (this.langArray == null) break block5;
                if (this.textArray != null) {
                    int length = this.langArray.length;
                    for (int i = 0; i < length; ++i) {
                        this.printLang(hp, this.langArray[i], this.textArray[i]);
                    }
                } else {
                    for (Lang lang : this.langArray) {
                        this.printLang(hp, lang);
                    }
                }
                break block6;
            }
            if (this.langs == null) break block6;
            for (Lang lang : this.langs) {
                this.printLang(hp, lang);
            }
        }
    }

    private void printLang(HtmlPrinter hp, Lang lang) {
        Label label;
        String labelString = "";
        if (this.labels != null && (label = this.labels.getLabel(lang)) != null) {
            labelString = label.getLabelString();
        }
        this.printLang(hp, lang, labelString);
    }

    private void printLang(HtmlPrinter hp, Lang lang, String value) {
        if (this.displayOnly) {
            this.printDisplayOnlyRow(hp, lang, value);
        } else if (this.rows == 1) {
            this.printSingleRow(hp, lang, value);
        } else {
            this.printTextAreaRow(hp, lang, value);
        }
    }

    private void printDisplayOnlyRow(HtmlPrinter hp, Lang lang, String value) {
        String inputClass = this.preformatted ? "grid-InputCell global-Preformatted" : "grid-InputCell";
        hp.__(Grid.START_ROW).__(Grid.labelCells(new Litteral(lang.toString()))).SPAN(inputClass).__escape(value, this.preformatted)._SPAN().__(Grid.END_ROW);
    }

    private void printSingleRow(HtmlPrinter hp, Lang lang, String value) {
        if (this.codemirrorMode == null) {
            value = FormSyntax.escapeString(value);
        }
        hp.__(Grid.textInputRow(new Litteral(lang.toString()), hp.name(this.namePrefix + lang.toString()).value(value).size(String.valueOf(this.cols))));
    }

    private void printTextAreaRow(HtmlPrinter hp, Lang lang, String value) {
        String finalValue = this.codemirrorMode == null ? FormSyntax.escapeString(value) : value;
        HtmlAttributes ha = hp.name(this.namePrefix + lang.toString()).rows(this.rows).cols(this.cols).attr("data-codemirror-mode", this.codemirrorMode);
        hp.__(Grid.textAreaInputRow((Object)new Litteral(lang.toString()), ha, () -> hp.__escape(finalValue, true)));
    }

    public static LangRows init(String namePrefix, @Nullable Labels labels, Langs langs) {
        return new LangRows(namePrefix, labels, langs);
    }

    public static LangRows init(String namePrefix, Lang[] langArray, String[] textArray) {
        return new LangRows(namePrefix, langArray, textArray);
    }
}

