/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TemplateRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TemplateRemove";
    public static final String COMMANDKEY = "_ EXP-32";
    private TemplateKey templateKey;

    public TemplateRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        this.bdfServer.getTransformationManager().removeTemplate(this.templateKey, editOrigin);
        this.setDone("_ done.exportation.templateremove", this.templateKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TemplateDescription templateDescription = this.requestHandler.getMandatoryTemplateDescription();
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        this.templateKey = templateDescription.getTemplateKey();
    }
}

