/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.ParseException;
import java.util.ArrayList;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.corpus.CorpusTools;
import net.fichotheque.tools.corpus.FieldGenerationEngine;
import net.fichotheque.tools.parsers.ficheblock.FicheBlockParser;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.TypoOptions;

public class SectionMergeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SectionMerge";
    public static final String COMMANDKEY = "_ CRP-32";
    public static final String ORIGIN_PARAMNAME = "origin";
    public static final String TRANSITIONTEXT_PARAMNAME = "transitiontext";
    public static final String DESTINATION_PARAMNAME = "destination";
    private Corpus corpus;
    private CorpusField originField;
    private CorpusField destinationField;
    private FicheBlocks transitionBlocks;

    public SectionMergeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            CorpusEditor corpusEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus);
            FieldGenerationEngine engine = BdfCommandUtils.buildEngine(this.requestHandler, this.corpus);
            FieldKey destinationKey = this.destinationField.getFieldKey();
            for (FicheMeta ficheMeta : this.corpus.getFicheMetaList()) {
                Fiche fiche = this.corpus.getFiche(ficheMeta);
                Section section = fiche.getSection(this.originField.getFieldKey());
                if (section == null || section.isEmpty()) continue;
                fiche.appendSection(destinationKey, this.transitionBlocks);
                fiche.appendSection(destinationKey, section);
                CorpusTools.saveFiche(corpusEditor, ficheMeta, fiche, engine, false);
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.setDone("_ done.corpus.sectionmerge", this.originField.getFieldKey().getKeyString(), this.destinationField.getFieldKey().getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_merge");
        }
        this.originField = this.getCorpusField(this.corpus, ORIGIN_PARAMNAME);
        this.destinationField = this.getCorpusField(this.corpus, DESTINATION_PARAMNAME);
        if (this.originField.getFieldKey().equals(this.destinationField.getFieldKey())) {
            throw BdfErrors.error("_ error.unsupported.samefield");
        }
        this.transitionBlocks = this.getTransitionFicheBlocks();
    }

    private CorpusField getCorpusField(Corpus corpus, String parameter) throws ErrorMessageException {
        String fieldName = this.getMandatory(parameter);
        try {
            FieldKey fieldKey = FieldKey.parse(fieldName);
            if (!fieldKey.isSection()) {
                throw BdfErrors.unsupportedParameterValue(parameter, fieldName);
            }
            CorpusField field = corpus.getCorpusMetadata().getCorpusField(fieldKey);
            if (field == null) {
                throw BdfErrors.unknownParameterValue(parameter, fieldName);
            }
            return field;
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(parameter, fieldName);
        }
    }

    private FicheBlocks getTransitionFicheBlocks() throws ErrorMessageException {
        if (!this.requestHandler.hasParameter(TRANSITIONTEXT_PARAMNAME)) {
            return FicheUtils.EMPTY_FICHEBLOCKS;
        }
        String text = this.requestHandler.getMandatoryParameter(TRANSITIONTEXT_PARAMNAME);
        if (text.isEmpty()) {
            return FicheUtils.EMPTY_FICHEBLOCKS;
        }
        TypoOptions typoOptions = BdfUserUtils.getTypoOptions(this.bdfUser);
        FicheBlockParser ficheBlockParser = new FicheBlockParser(this.bdfServer.getHtmlCleaner(), typoOptions, false);
        ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
        ficheBlockParser.parseFicheBlockList(text, list);
        return FicheUtils.toFicheBlocks(list);
    }
}

