/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.api.instruction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.extraction.builders.ExtractionContextBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;

public interface BdfParameters {
    public BdfServer getBdfServer();

    public BdfUser getBdfUser();

    public PermissionSummary getPermissionSummary();

    default public Fichotheque getFichotheque() {
        return this.getBdfServer().getFichotheque();
    }

    default public Lang getWorkingLang() {
        return this.getBdfUser().getWorkingLang();
    }

    default public UserLangContext getUserLangContext() {
        return this.getBdfUser();
    }

    default public MessageLocalisation getMessageLocalisation() {
        return this.getBdfServer().getL10nManager().getMessageLocalisation(this.getBdfUser());
    }

    default public boolean isFichothequeAdmin() {
        return this.getBdfServer().getPermissionManager().isAdmin(this.getBdfUser().getRedacteur());
    }

    default public ExtractionContextBuilder getExtractionContextBuilder() {
        return BdfServerUtils.initExtractionContextBuilder(this.getBdfServer(), this.getBdfUser(), this.getPermissionSummary());
    }

    default public ExtractionContext getDefaultExtractionContext() {
        return this.getExtractionContextBuilder().toExtractionContext();
    }

    default public Map<String, String> getStoredValues(String storeName) {
        return this.getBdfServer().getStoredValues(this.getBdfUser(), storeName);
    }
}

