/* UtilLib - Copyright (c) 2023-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.mapeadores.util.logging;


/**
 *
 * @author Vincent Calame
 */
public class LineMessageException extends Exception {

    private final LineMessage lineMessage;

    public LineMessageException(int lineNumber, String category, String messageKey) {
        super(messageKey);
        this.lineMessage = LogUtils.toLineMessage(category, lineNumber, messageKey);
    }

    public LineMessageException(int lineNumber, String category, String messageKey, Object... values) {
        super(messageKey);
        this.lineMessage = LogUtils.toLineMessage(category, lineNumber, messageKey, values);
    }

    public LineMessageException(String category, LineMessage lineMessage) {
        super(lineMessage.getMessageKey());
        this.lineMessage = lineMessage;
    }

    public LineMessage getLineMessage() {
        return lineMessage;
    }

}
