/* FichothequeLib_Tools - Copyright (c) 2013-202( Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.junction;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetItem;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.JunctionUtils;


/**
 *
 * @author Vincent Calame
 */
public class JunctionChangesBuilder {

    private final List<SubsetItem> removedList = new ArrayList<SubsetItem>();
    private final List<JunctionChanges.Entry> entryList = new ArrayList<JunctionChanges.Entry>();


    public JunctionChangesBuilder() {
    }

    public JunctionChangesBuilder addRemoved(SubsetItem subsetItem) {
        removedList.add(subsetItem);
        return this;
    }

    public JunctionChangesBuilder addEntry(SubsetItem subsetItem, JunctionChange junctionChange) {
        entryList.add(JunctionUtils.toEntry(subsetItem, junctionChange));
        return this;
    }

    public JunctionChanges toJunctionChanges() {
        List<SubsetItem> finalRemovedList = FichothequeUtils.wrap(removedList.toArray(new SubsetItem[removedList.size()]));
        List<JunctionChanges.Entry> finalEntryList = JunctionUtils.wrap(entryList.toArray(new JunctionChanges.Entry[entryList.size()]));
        return new InternalJunctionChanges(finalRemovedList, finalEntryList);
    }

    public static JunctionChangesBuilder init() {
        return new JunctionChangesBuilder();
    }


    private static class InternalJunctionChanges implements JunctionChanges {

        private final List<SubsetItem> removedList;
        private final List<JunctionChanges.Entry> entryList;

        private InternalJunctionChanges(List<SubsetItem> removedList, List<JunctionChanges.Entry> entryList) {
            this.removedList = removedList;
            this.entryList = entryList;
        }

        @Override
        public List<SubsetItem> getRemovedList() {
            return removedList;
        }

        @Override
        public List<Entry> getEntryList() {
            return entryList;
        }

    }

}
