/* FichothequeLib_Tools - Copyright (c) 2009-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.mapeadores.util.exceptions.SwitchException;


/**
 *
 * @author Vincent Calame
 */
public class SubfieldTokenizerFactory {

    private SubfieldTokenizerFactory() {
    }

    public static Tokenizer newInstance(CorpusField corpusField, SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter) {
        switch (subfieldKey.getSubtype()) {
            case SubfieldKey.SURNAME_SUBTYPE:
            case SubfieldKey.FORENAME_SUBTYPE:
            case SubfieldKey.NONLATIN_SUBTYPE:
            case SubfieldKey.SURNAMEFIRST_SUBTYPE:
                return new PersonPropTokenizer(subfieldKey, subfieldFormatter);
            case SubfieldKey.SRC_SUBTYPE:
            case SubfieldKey.ALT_SUBTYPE:
            case SubfieldKey.TITLE_SUBTYPE:
                return new ImagePropTokenizer(subfieldKey, subfieldFormatter);
            case SubfieldKey.CURRENCY_SUBTYPE:
            case SubfieldKey.VALUE_SUBTYPE:
                return new AmountPropTokenizer(subfieldKey, subfieldFormatter);
            case SubfieldKey.LATITUDE_SUBTYPE:
            case SubfieldKey.LONGITUDE_SUBTYPE:
                return new GeopointInfoTokenizer(subfieldKey, subfieldFormatter);
            case SubfieldKey.OTHERS_SUBTYPE:
            case SubfieldKey.AMOUNT_SUBTYPE:
                return new AmountInfoTokenizer(corpusField, subfieldKey, subfieldFormatter);
            case SubfieldKey.LANG_SUBTYPE:
            default:
                throw new SwitchException("subfieldType = " + subfieldKey.getSubtype());
        }
    }

}
