/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.format.catalogs;

import net.fichotheque.tools.format.FicheBlockFormat;
import net.fichotheque.tools.format.ValuesParameters;
import java.io.IOException;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.syntax.FicheblockSyntax;


/**
 *
 * @author Vincent Calame
 */
public final class FicheBlockFormatterCatalog {

    private final static FicheblockSyntax.Parameters DEFAULT_PARAMETERS = FicheblockSyntax.parameters().withSpecialParseChars(true);
    public final static FicheBlockFormatter FORMSYNTAX = (ficheBlocks, formatSource, defaultCorpusKey) -> {
        return FicheblockSyntax.toString(ficheBlocks, DEFAULT_PARAMETERS);
    };
    public final static FicheBlockFormatter TEXT = (ficheBlocks, formatSource, defaultCorpusKey) -> {
        StringBuilder appendable = new StringBuilder();
        try {
            FicheBlockFormat.textFormat(appendable, ficheBlocks, "\n");
        } catch (IOException ioe) {
        }
        return appendable.toString();
    };

    private FicheBlockFormatterCatalog() {

    }


    public static class Values implements FicheBlockFormatter {

        private final ValuesParameters valuesParameters;

        public Values(ValuesParameters valuesParameters) {
            this.valuesParameters = valuesParameters;
        }

        @Override
        public String formatFicheBlocks(FicheBlocks ficheBlocks, FormatSource formatSource, SubsetKey defaultCorpusKey) {
            int limit = valuesParameters.getLimit();
            int startIndex = valuesParameters.getStartIndex();
            String separator = valuesParameters.getSeparator();
            List<String> list = FicheBlockFormat.valuesFormat(ficheBlocks);
            int size = list.size();
            if (limit != -1) {
                size = Math.min(size, startIndex + limit);
            }
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (int i = startIndex; i < size; i++) {
                if (first) {
                    first = false;
                } else {
                    buf.append(separator);
                }
                buf.append(list.get(i));
            }
            return buf.toString();
        }

    }

}
