/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.format.catalogs;

import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.AttributeFormatter;


/**
 *
 * @author Vincent Calame
 */
public final class AttributeFormatterCatalog {

    public final static AttributeFormatter VALUE = (attributeValue, valueIndex, formatSource) -> {
        return attributeValue;
    };
    public final static AttributeFormatter FORMSYNTAX = new InternalFormSyntax();

    private AttributeFormatterCatalog() {

    }


    private static class InternalFormSyntax implements AttributeFormatter {

        private InternalFormSyntax() {

        }

        @Override
        public String formatAttributeValue(String attributeValue, int valueIndex, FormatSource formatSource) {
            int length = attributeValue.length();
            StringBuilder buf = new StringBuilder(length + 20);
            for (int i = 0; i < length; i++) {
                char carac = attributeValue.charAt(i);
                switch (carac) {
                    case ';':
                        buf.append("\\;");
                        break;
                    case '\\':
                        buf.append("\\\\");
                        break;
                    default:
                        buf.append(carac);
                        break;
                }
            }
            return buf.toString();
        }

    }

}
