/* FichothequeLib_Tools - Copyright (c) 2012-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.alias;

import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MessageHandler;


/**
 *
 * @author Vincent Calame
 */
public class AliasUtils {

    public final static String SEVERE_ALIAS = "severe.alias";

    private AliasUtils() {
    }

    public static boolean testDateProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            wrongFieldCategory(messageHandler, alias, corpusField, FieldKey.PROP_CATEGORY_STRING);
            return false;
        }
        if (!corpusField.isType(CorpusField.DATE_FIELD)) {
            wrongFicheItemType(messageHandler, alias, corpusField, CorpusField.DATE_FIELD);
            return false;
        }
        return true;
    }

    public static boolean testAmountProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            wrongFieldCategory(messageHandler, alias, corpusField, FieldKey.PROP_CATEGORY_STRING);
            return false;
        }
        if (!corpusField.isType(CorpusField.AMOUNT_FIELD)) {
            wrongFicheItemType(messageHandler, alias, corpusField, CorpusField.AMOUNT_FIELD);
            return false;
        }
        return true;
    }

    public static boolean testNumberProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            wrongFieldCategory(messageHandler, alias, corpusField, FieldKey.PROP_CATEGORY_STRING);
            return false;
        }
        if (!corpusField.isType(CorpusField.NUMBER_FIELD)) {
            wrongFicheItemType(messageHandler, alias, corpusField, CorpusField.NUMBER_FIELD);
            return false;
        }
        return true;
    }

    public static boolean testPersonProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            wrongFieldCategory(messageHandler, alias, corpusField, FieldKey.PROP_CATEGORY_STRING);
            return false;
        }
        if (!corpusField.isType(CorpusField.PERSON_FIELD)) {
            wrongFicheItemType(messageHandler, alias, corpusField, CorpusField.PERSON_FIELD);
            return false;
        }
        return true;
    }

    public static boolean testItemProp(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isProp()) {
            wrongFieldCategory(messageHandler, alias, corpusField, FieldKey.PROP_CATEGORY_STRING);
            return false;
        }
        if (!corpusField.isType(CorpusField.ITEM_FIELD)) {
            wrongFicheItemType(messageHandler, alias, corpusField, CorpusField.ITEM_FIELD);
            return false;
        }
        return true;
    }

    public static boolean testDateInfo(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isInfo()) {
            wrongFieldCategory(messageHandler, alias, corpusField, FieldKey.INFO_CATEGORY_STRING);
            return false;
        }
        if (!corpusField.isType(CorpusField.DATE_FIELD)) {
            wrongFicheItemType(messageHandler, alias, corpusField, CorpusField.DATE_FIELD);
            return false;
        }
        return true;
    }

    public static boolean testAmountInfo(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isInfo()) {
            wrongFieldCategory(messageHandler, alias, corpusField, FieldKey.INFO_CATEGORY_STRING);
            return false;
        }
        if (!corpusField.isType(CorpusField.AMOUNT_FIELD)) {
            wrongFicheItemType(messageHandler, alias, corpusField, CorpusField.AMOUNT_FIELD);
            return false;
        }
        return true;
    }

    public static boolean testLanguageInfo(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isInfo()) {
            wrongFieldCategory(messageHandler, alias, corpusField, FieldKey.INFO_CATEGORY_STRING);
            return false;
        }
        if (!corpusField.isType(CorpusField.LANGUAGE_FIELD)) {
            wrongFicheItemType(messageHandler, alias, corpusField, CorpusField.LANGUAGE_FIELD);
            return false;
        }
        return true;
    }

    public static void unknownAlias(MessageHandler messageHandler, String aliasType, String alias) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.unknown.alias", aliasType, alias);
    }

    public static void missingSubset(MessageHandler messageHandler, String alias, SubsetKey subsetKey) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.unknown.alias.subset", alias, subsetKey);
    }

    public static void missingField(MessageHandler messageHandler, String alias, FieldKey fieldKey) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.unknown.alias.field", alias, fieldKey);
    }

    public static void wrongFieldCategory(MessageHandler messageHandler, String alias, CorpusField corpusField, String expectedCategories) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.wrong.alias.fieldcategory", alias, corpusField.getFieldString(), expectedCategories);
    }

    public static void wrongFicheItemType(MessageHandler messageHandler, String alias, CorpusField corpusField, String expectedFicheItemType) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.wrong.alias.itemtype", alias, corpusField.getFieldString(), expectedFicheItemType);
    }


    public static class ErrorHandler implements MessageHandler {

        private final MessageHandler wrappedHandler;
        private boolean withError = false;

        public ErrorHandler(MessageHandler wrappedHandler) {
            this.wrappedHandler = wrappedHandler;
        }

        public boolean isWithError() {
            return withError;
        }

        @Override
        public void addMessage(String category, Message message) {
            if (category.equals(SEVERE_ALIAS)) {
                withError = true;
            }
            wrappedHandler.addMessage(category, message);
        }

    }

}
