/* FichothequeLib_API - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.junction;


/**
 *
 * @author Vincent Calame
 */
public final class LiaisonWeightSortKey implements Comparable<LiaisonWeightSortKey> {

    private int weight;
    private final int id;
    private final int position;

    public LiaisonWeightSortKey(int weight, int id, int position) {
        this.id = id;
        this.position = position;
    }

    @Override
    public int hashCode() {
        return id * 1000 + position * 10 + weight;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        LiaisonWeightSortKey otherLiaisonWeightSortKey = (LiaisonWeightSortKey) other;
        return ((otherLiaisonWeightSortKey.id == this.id) && (otherLiaisonWeightSortKey.position == this.position) && (otherLiaisonWeightSortKey.weight == this.weight));
    }

    @Override
    public String toString() {
        return id + "/" + position;
    }

    @Override
    public int compareTo(LiaisonWeightSortKey otherLiaisonWeightSortKey) {
        if (otherLiaisonWeightSortKey.weight > this.weight) {
            return - 1;
        }
        if (otherLiaisonWeightSortKey.weight < this.weight) {
            return 1;
        }
        if (otherLiaisonWeightSortKey.position < 1) {
            if (this.position < 1) {
                return compareId(otherLiaisonWeightSortKey);
            } else {
                return -1;
            }
        } else if (this.position < 1) {
            return 1;
        } else if (otherLiaisonWeightSortKey.position > this.position) {
            return -1;
        } else if (otherLiaisonWeightSortKey.position < this.position) {
            return 1;
        } else {
            return compareId(otherLiaisonWeightSortKey);
        }
    }

    private int compareId(LiaisonWeightSortKey otherLiaisonWeightSortKey) {
        if (otherLiaisonWeightSortKey.id > this.id) {
            return -1;
        } else if (otherLiaisonWeightSortKey.id < this.id) {
            return 1;
        } else {
            return 0;
        }
    }

}
