/* FichothequeLib_API - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.importation;

import java.util.List;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.text.LabelChange;


/**
 *
 * @author Vincent Calame
 */
public interface ThesaurusImport {

    public final static String EDIT_TYPE = "edit";
    public final static String REMOVE_TYPE = "remove";
    public final static String MERGE_TYPE = "merge";
    public final static String MOVE_TYPE = "move";

    public Thesaurus getThesaurus();

    /**
     * Non nul si getType() = MERGE_TYPE ou MOVE_TYPE
     */
    public Thesaurus getDestinationThesaurus();

    public String getType();

    public List<MotcleImport> getMotcleImportList();

    public static String checkType(String type) {
        switch (type) {
            case "creation":
            case "change":
            case EDIT_TYPE:
                return EDIT_TYPE;
            case REMOVE_TYPE:
                return REMOVE_TYPE;
            case MERGE_TYPE:
                return MERGE_TYPE;
            case MOVE_TYPE:
                return MOVE_TYPE;
            default:
                throw new IllegalArgumentException("Unknown type: " + type);
        }
    }


    public interface MotcleImport {

        public int getMotcleId();

    }


    public interface EditMotcleImport extends MotcleImport {

        public String getNewIdalpha();

        public String getNewStatus();

        public LabelChange getLabelChange();

        public AttributeChange getAttributeChange();

        public TiesImport getTiesImport();

        public ParentChange getParentChange();

    }


    public interface MergeMotcleImport extends MotcleImport {

        public Motcle getDestinationMotcle();

    }

}
