/* FichothequeLib_API - Copyright (c) 2012-2024 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.exportation.table;

import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FichothequeFormatDef;
import net.fichotheque.format.FormatSourceKey;


/**
 *
 * @author Vincent Calame
 */
public interface FormatColDef extends ColDef, TableDefItem {

    public FichothequeFormatDef getFichothequeFormatDef();

    @Override
    public default Object getParameterValue(String paramKey) {
        return getFichothequeFormatDef().getParameterValue(paramKey);
    }

    @Override
    public default String getMatchingComponentName() {
        FormatSourceKey firstSourceKey = getFichothequeFormatDef().getFormatSourceKeyList().get(0);
        if (firstSourceKey.getSubsetPathKey() != null) {
            return "";
        }
        Object keyObject = firstSourceKey.getKeyObject();
        switch (firstSourceKey.getSourceType()) {
            case FormatSourceKey.SUBFIELDKEY_TYPE:
                SubfieldKey subfieldKey = (SubfieldKey) keyObject;
                return subfieldKey.getFieldKey().toString();
            case FormatSourceKey.SPECIALINCLUDENAME_TYPE:
            case FormatSourceKey.FIELDKEY_TYPE:
            case FormatSourceKey.INCLUDEKEY_TYPE:
            case FormatSourceKey.ID_TYPE:
            case FormatSourceKey.LANG_TYPE:
                return firstSourceKey.getKeyString();
            default:
                return "";
        }
    }

}
