/* FichothequeLib_API - Copyright (c) 2010-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.album;


/**
 *
 * @author Vincent Calame
 */
public interface AlbumConstants {

    public final static String JPG_FORMATTYPE = "jpg";
    public final static String PNG_FORMATTYPE = "png";
    public final static String FIXEDWIDTH_DIMTYPE = "fixed-width";
    public final static String FIXEDHEIGHT_DIMTYPE = "fixed-height";
    public final static String MAXWIDTH_DIMTYPE = "max-width";
    public final static String MAXHEIGHT_DIMTYPE = "max-height";
    public final static String MAXDIM_DIMTYPE = "max-dim";
    public final static String MINI_SPECIALDIM = "_mini";
    public final static String ORIGINAL_SPECIALDIM = "_original";
    public final static String VIGNETTE_USAGE = "vignette";
    public final static String DETAIL_USAGE = "detail";

    public static String checkDimType(String dimType) {
        switch (dimType) {
            case AlbumConstants.FIXEDWIDTH_DIMTYPE:
                return AlbumConstants.FIXEDWIDTH_DIMTYPE;
            case AlbumConstants.FIXEDHEIGHT_DIMTYPE:
                return AlbumConstants.FIXEDHEIGHT_DIMTYPE;
            case AlbumConstants.MAXWIDTH_DIMTYPE:
                return AlbumConstants.MAXWIDTH_DIMTYPE;
            case AlbumConstants.MAXHEIGHT_DIMTYPE:
                return AlbumConstants.MAXHEIGHT_DIMTYPE;
            case AlbumConstants.MAXDIM_DIMTYPE:
                return AlbumConstants.MAXDIM_DIMTYPE;
            default:
                throw new IllegalArgumentException("unknown type " + dimType);
        }
    }

    public static String checkFormatType(String formatType) {
        formatType = formatType.toLowerCase();
        switch (formatType) {
            case AlbumConstants.PNG_FORMATTYPE:
                return AlbumConstants.PNG_FORMATTYPE;
            case AlbumConstants.JPG_FORMATTYPE:
            case "jpeg":
                return AlbumConstants.JPG_FORMATTYPE;
            default:
                throw new IllegalArgumentException("unknown type " + formatType);
        }
    }

    public static String checkSpecialDim(String specialDim) {
        switch (specialDim) {
            case AlbumConstants.ORIGINAL_SPECIALDIM:
                return AlbumConstants.ORIGINAL_SPECIALDIM;
            case AlbumConstants.MINI_SPECIALDIM:
                return AlbumConstants.MINI_SPECIALDIM;
            default:
                throw new IllegalArgumentException("Unknown specialDim : " + specialDim);
        }
    }

    public static boolean needWidth(String dimType) {
        switch (dimType) {
            case AlbumConstants.FIXEDWIDTH_DIMTYPE:
            case AlbumConstants.MAXWIDTH_DIMTYPE:
            case AlbumConstants.MAXDIM_DIMTYPE:
                return true;
            default:
                return false;
        }
    }

    public static boolean needHeight(String dimType) {
        switch (dimType) {
            case AlbumConstants.FIXEDHEIGHT_DIMTYPE:
            case AlbumConstants.MAXHEIGHT_DIMTYPE:
            case AlbumConstants.MAXDIM_DIMTYPE:
                return true;
            default:
                return false;
        }
    }

}
