/* BdfServer_JsonProducers - Copyright (c) 2012-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.jsonproducers.main;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.interaction.domains.MainDomain;
import fr.exemole.bdfserver.tools.exportation.table.CellConversionInit;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import fr.exemole.bdfserver.tools.interaction.PropertiesParam;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.table.SubsetTable;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.logging.ErrorMessageException;


/**
 *
 * @author Vincent Calame
 */
public final class MainJsonProducerFactory {

    private MainJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        String json = parameters.getOutput();
        ResultJsonProducer jsonProducer = new ResultJsonProducer(parameters);
        JsonProperty jsonProperty = getJsonProperty(parameters, json);
        if (jsonProperty == null) {
            return null;
        } else {
            jsonProducer.add(jsonProperty);
            return jsonProducer;
        }
    }

    public static JsonProperty getJsonProperty(OutputParameters parameters, String name) throws ErrorMessageException {
        switch (name) {
            case MainDomain.AVAILABLEPATTERNS_JSON: {
                return new AvailablePatternsJsonProperty(parameters.getBdfServer(), parameters.getBdfUser());
            }
            case MainDomain.TABLE_JSON: {
                return getTableJsonProperty(parameters);
            }
            default:
                return null;
        }
    }

    private static JsonProperty getTableJsonProperty(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        BdfServer bdfServer = parameters.getBdfServer();
        Subset subset = requestHandler.seekSubset();
        PropertiesParam propertiesParam = PropertiesParam.fromRequest(requestHandler.getRequestMap(), PropertiesParam.USERDEFAULT);
        CellConversionInit.Result result = CellConversionInit.EMPTY_RESULT;
        switch (propertiesParam.getType()) {
            case PropertiesParam.TABLEEXPORT_TYPE: {
                result = CellConversionInit.fromTableExportName(bdfServer, requestHandler.getDefaultExtractionContext(), propertiesParam.getName());
                break;
            }
            case PropertiesParam.COMPONENTS_TYPE: {
                if (subset instanceof Corpus) {
                    String patternMode = BdfInstructionUtils.getPatternMode(requestHandler);
                    result = CellConversionInit.components(requestHandler, propertiesParam.getComponentNameList(), patternMode, (Corpus) subset);
                }
                break;
            }
            case PropertiesParam.SPECIAL_TYPE: {
                switch (propertiesParam.getName()) {
                    case PropertiesParam.USERDEFAULT_SPECIAL: {
                        result = CellConversionInit.subsetDefault(parameters, subset);
                    }
                }
                break;
            }
        }
        SubsetTable subsetTable = result.getSubsetTable(subset);
        if (subsetTable == null) {
            throw BdfErrors.error("_ tableexport_err_notableexportcontent", propertiesParam.getName(), subset.getSubsetKeyString());
        }
        return new TableJsonProperty(parameters, subsetTable, bdfServer.getTableExportContext(), result.getCellConverter(), propertiesParam.getCompleteString(), true);
    }


}
