/* BdfServer_DirectoryStorage - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.Remove;
import fr.exemole.bdfserver.storage.directory.bdfdata.Save;
import fr.exemole.bdfserver.storage.directory.jdbm.FichothequeJdbm;
import java.io.File;
import net.fichotheque.EditOrigin;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.impl.AddendaDataSource;
import net.fichotheque.impl.AlbumDataSource;
import net.fichotheque.impl.CorpusDataSource;
import net.fichotheque.impl.FichothequeDataSource;
import net.fichotheque.impl.JunctionDataSource;
import net.fichotheque.impl.SphereDataSource;
import net.fichotheque.impl.ThesaurusDataSource;
import net.fichotheque.metadata.FichothequeMetadata;


/**
 *
 * @author Vincent Calame
 */
public class FichothequeDataSourceImpl implements FichothequeDataSource {

    private final StorageDirectory bdfdataDirectory;
    private final AddendaDataSourceImpl addendaDataSourceImpl;
    private final AlbumDataSourceImpl albumDataSourceImpl;
    private final CorpusDataSourceImpl corpusDataSourceImpl;
    private final SphereDataSourceImpl sphereDataSourceImpl;
    private final ThesaurusDataSourceImpl thesaurusDataSourceImpl;
    private final JunctionDataSourceImpl junctionDataSourceImpl;

    public FichothequeDataSourceImpl(StorageDirectory bdfdataDirectory, File cacheDir, FichothequeJdbm fichothequeJdbm) {
        this.bdfdataDirectory = bdfdataDirectory;
        this.addendaDataSourceImpl = new AddendaDataSourceImpl(bdfdataDirectory);
        this.albumDataSourceImpl = new AlbumDataSourceImpl(bdfdataDirectory, cacheDir);
        this.corpusDataSourceImpl = new CorpusDataSourceImpl(bdfdataDirectory, fichothequeJdbm);
        this.sphereDataSourceImpl = new SphereDataSourceImpl(bdfdataDirectory);
        this.thesaurusDataSourceImpl = new ThesaurusDataSourceImpl(bdfdataDirectory);
        this.junctionDataSourceImpl = new JunctionDataSourceImpl(bdfdataDirectory);
    }

    @Override
    public AddendaDataSource getAddendaDataSource() {
        return addendaDataSourceImpl;
    }

    @Override
    public AlbumDataSource getAlbumDataSource() {
        return albumDataSourceImpl;
    }

    @Override
    public CorpusDataSource getCorpusDataSource() {
        return corpusDataSourceImpl;
    }

    @Override
    public SphereDataSource getSphereDataSource() {
        return sphereDataSourceImpl;
    }

    @Override
    public ThesaurusDataSource getThesaurusDataSource() {
        return thesaurusDataSourceImpl;
    }

    @Override
    public JunctionDataSource getJunctionDataSource() {
        return junctionDataSourceImpl;
    }

    @Override
    public void saveFichothequeMetadata(FichothequeMetadata fichothequeMetadata, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Save.saveFichothequeMetadata(bdfdataDirectory, fichothequeMetadata, editOrigin);
    }

    @Override
    public void removeAddenda(SubsetKey addendaKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeAddenda(bdfdataDirectory, addendaKey, editOrigin);
    }

    @Override
    public void removeAlbum(SubsetKey albumKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeAlbum(bdfdataDirectory, albumKey, editOrigin);
    }

    @Override
    public void removeCorpus(SubsetKey corpusKey, Subset masterSubset, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeCorpus(bdfdataDirectory, corpusKey, masterSubset, editOrigin);
    }

    @Override
    public void removeSphere(SubsetKey sphereKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeSphere(bdfdataDirectory, sphereKey, editOrigin);
    }

    @Override
    public void removeThesaurus(SubsetKey thesaurusKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeThesaurus(bdfdataDirectory, thesaurusKey, editOrigin);
    }

}
