/* BdfServer - Copyright (c) 2019-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.tools.subsettree;

import fr.exemole.bdfserver.api.subsettree.JunctionSubsetNode;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.junction.Junctions;


/**
 *
 * @author Vincent Calame
 */
public class JunctionSubsetNodeBuilder {

    private final Subset subset;
    private final Junctions junctions;

    public JunctionSubsetNodeBuilder(Subset subset, Junctions junctions) {
        if (subset == null) {
            throw new IllegalArgumentException("subset is null");
        }
        if (junctions == null) {
            throw new IllegalArgumentException("junctions is null");
        }
        this.subset = subset;
        this.junctions = junctions;
    }

    public JunctionSubsetNode toJunctionSubsetNode() {
        return new InternalJunctionSubsetNode(subset, junctions);
    }

    public JunctionSubsetNodeBuilder init(Subset subset, Junctions junctions) {
        return new JunctionSubsetNodeBuilder(subset, junctions);
    }

    public static JunctionSubsetNode build(Subset subset, Junctions junctions) {
        if (subset == null) {
            throw new IllegalArgumentException("subset is null");
        }
        if (junctions == null) {
            throw new IllegalArgumentException("junctions is null");
        }
        return new InternalJunctionSubsetNode(subset, junctions);
    }


    private static class InternalJunctionSubsetNode implements JunctionSubsetNode {

        private final Subset subset;
        private final Junctions junctions;

        private InternalJunctionSubsetNode(Subset subset, Junctions junctions) {
            this.subset = subset;
            this.junctions = junctions;
        }

        @Override
        public SubsetKey getSubsetKey() {
            return subset.getSubsetKey();
        }

        @Override
        public Subset getSubset() {
            return subset;
        }

        @Override
        public Junctions getJunctions() {
            return junctions;
        }

    }

}
