/* BdfServer - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.tools.jslib;

import fr.exemole.bdfserver.tools.apps.AppConf;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.text.ParseException;
import java.util.Map;
import java.util.SortedMap;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.JsLib;
import net.mapeadores.util.jslib.TemplateFamily;
import net.mapeadores.util.jslib.TemplateFamilyBuilder;
import net.mapeadores.util.text.RelativePath;


/**
 *
 * @author Vincent Calame
 */
public final class AppJsLibFactory {

    private final ResourceStorages resourceStorages;
    private final AppConf appConf;
    private final BdfJsLibBuilder jsLibBuilder = new BdfJsLibBuilder();
    private final RelativePath appDir;

    private AppJsLibFactory(ResourceStorages resourceStorages, AppConf appConf) {
        this.resourceStorages = resourceStorages;
        this.appConf = appConf;
        this.appDir = StorageUtils.buildAppResourcePath(appConf.getAppName(), "");

    }

    public static JsLib newInstance(ResourceStorages resourceStorages, AppConf appConf) {
        AppJsLibFactory factory = new AppJsLibFactory(resourceStorages, appConf);
        factory.run();
        return factory.toJsLib();
    }

    private void run() {
        for (String js : appConf.getArray(AppConf.CORE_JSORDER)) {
            try {
                RelativePath jsPath = appDir.parseChild("js/" + js);
                jsLibBuilder.addJsScript(jsPath);
            } catch (ParseException pe) {

            }
        }
        SortedMap<String, RelativePath> subFolders = resourceStorages.listSubFolders(appDir);
        for (Map.Entry<String, RelativePath> entry : subFolders.entrySet()) {
            RelativePath subfolderPath = entry.getValue();
            switch (entry.getKey()) {
                case "templates":
                    TemplateFamily appTemplateFamily = TemplateFamilyBuilder.init("")
                            .setPath(subfolderPath)
                            .toTemplateFamily();
                    jsLibBuilder.addTemplateFamily(appTemplateFamily);
                    break;
                case "js":
                    jsLibBuilder.scanJavascriptFolder(resourceStorages, subfolderPath);
                    break;
                case "ns-templates":
                    addNamedTemplateFamilies(subfolderPath);
                    break;

            }
        }
    }

    private void addNamedTemplateFamilies(RelativePath folder) {
        SortedMap<String, RelativePath> subFolders = resourceStorages.listSubFolders(folder);
        for (Map.Entry<String, RelativePath> entry : subFolders.entrySet()) {
            String name = entry.getKey();
            RelativePath subfolderPath = entry.getValue();
            TemplateFamily appTemplateFamily = TemplateFamilyBuilder.init(name)
                    .setPath(subfolderPath)
                    .toTemplateFamily();
            jsLibBuilder.addTemplateFamily(appTemplateFamily);
        }

    }

    private JsLib toJsLib() {
        return jsLibBuilder.toJsLib();
    }

}
